/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.item.ItemMetaBlock;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.BlockAlchemicalCauldron;
import de.teamlapen.vampirism.blocks.BlockAlchemicalFire;
import de.teamlapen.vampirism.blocks.BlockAltarInfusion;
import de.teamlapen.vampirism.blocks.BlockAltarInspiration;
import de.teamlapen.vampirism.blocks.BlockAltarPillar;
import de.teamlapen.vampirism.blocks.BlockAltarTip;
import de.teamlapen.vampirism.blocks.BlockBloodContainer;
import de.teamlapen.vampirism.blocks.BlockBloodPotionTable;
import de.teamlapen.vampirism.blocks.BlockCastleBlock;
import de.teamlapen.vampirism.blocks.BlockCastleSlab;
import de.teamlapen.vampirism.blocks.BlockCastleStairs;
import de.teamlapen.vampirism.blocks.BlockChurchAltar;
import de.teamlapen.vampirism.blocks.BlockCoffin;
import de.teamlapen.vampirism.blocks.BlockCursedEarth;
import de.teamlapen.vampirism.blocks.BlockFirePlace;
import de.teamlapen.vampirism.blocks.BlockFluidBlood;
import de.teamlapen.vampirism.blocks.BlockGarlic;
import de.teamlapen.vampirism.blocks.BlockGarlicBeacon;
import de.teamlapen.vampirism.blocks.BlockGrinder;
import de.teamlapen.vampirism.blocks.BlockHunterTable;
import de.teamlapen.vampirism.blocks.BlockMedChair;
import de.teamlapen.vampirism.blocks.BlockPedestal;
import de.teamlapen.vampirism.blocks.BlockSieve;
import de.teamlapen.vampirism.blocks.BlockSunscreenBeacon;
import de.teamlapen.vampirism.blocks.BlockTent;
import de.teamlapen.vampirism.blocks.BlockTentMain;
import de.teamlapen.vampirism.blocks.BlockTotemBase;
import de.teamlapen.vampirism.blocks.BlockTotemTop;
import de.teamlapen.vampirism.blocks.BlockWeaponTable;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.blocks.VampirismFlower;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.tileentity.TileAlchemicalCauldron;
import de.teamlapen.vampirism.tileentity.TileAltarInfusion;
import de.teamlapen.vampirism.tileentity.TileAltarInspiration;
import de.teamlapen.vampirism.tileentity.TileBloodContainer;
import de.teamlapen.vampirism.tileentity.TileCoffin;
import de.teamlapen.vampirism.tileentity.TileGarlicBeacon;
import de.teamlapen.vampirism.tileentity.TileGrinder;
import de.teamlapen.vampirism.tileentity.TilePedestal;
import de.teamlapen.vampirism.tileentity.TileSieve;
import de.teamlapen.vampirism.tileentity.TileSunscreenBeacon;
import de.teamlapen.vampirism.tileentity.TileTent;
import de.teamlapen.vampirism.tileentity.TileTotem;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="vampirism")
public class ModBlocks {
    public static final BlockFluidBlood block_blood_fluid = (BlockFluidBlood)((Object)UtilLib.getNull());
    public static final BlockFluidBlood block_impure_blood_fluid = (BlockFluidBlood)((Object)UtilLib.getNull());
    public static final BlockCastleBlock castle_block = (BlockCastleBlock)((Object)UtilLib.getNull());
    public static final BlockCursedEarth cursed_earth = (BlockCursedEarth)((Object)UtilLib.getNull());
    public static final VampirismFlower vampirism_flower = (VampirismFlower)UtilLib.getNull();
    public static final BlockTent tent = (BlockTent)((Object)UtilLib.getNull());
    public static final BlockTentMain tent_main = (BlockTentMain)((Object)UtilLib.getNull());
    public static final BlockCoffin block_coffin = (BlockCoffin)((Object)UtilLib.getNull());
    public static final BlockAltarInfusion altar_infusion = (BlockAltarInfusion)((Object)UtilLib.getNull());
    public static final BlockAltarPillar altar_pillar = (BlockAltarPillar)((Object)UtilLib.getNull());
    public static final BlockAltarTip altar_tip = (BlockAltarTip)((Object)UtilLib.getNull());
    public static final BlockHunterTable hunter_table = (BlockHunterTable)((Object)UtilLib.getNull());
    public static final BlockHunterTable hunter_table2 = (BlockHunterTable)((Object)UtilLib.getNull());
    public static final BlockMedChair med_chair = (BlockMedChair)((Object)UtilLib.getNull());
    public static final BlockGarlic garlic = (BlockGarlic)((Object)UtilLib.getNull());
    public static final BlockChurchAltar church_altar = (BlockChurchAltar)((Object)UtilLib.getNull());
    public static final BlockBloodContainer blood_container = (BlockBloodContainer)((Object)UtilLib.getNull());
    public static final BlockAltarInspiration altar_inspiration = (BlockAltarInspiration)((Object)UtilLib.getNull());
    public static final BlockFirePlace fire_place = (BlockFirePlace)((Object)UtilLib.getNull());
    public static final BlockWeaponTable weapon_table = (BlockWeaponTable)((Object)UtilLib.getNull());
    public static final BlockBloodPotionTable blood_potion_table = (BlockBloodPotionTable)((Object)UtilLib.getNull());
    public static final BlockSunscreenBeacon sunscreen_beacon = (BlockSunscreenBeacon)((Object)UtilLib.getNull());
    public static final BlockAlchemicalFire alchemical_fire = (BlockAlchemicalFire)((Object)UtilLib.getNull());
    public static final BlockAlchemicalCauldron alchemical_cauldron = (BlockAlchemicalCauldron)((Object)UtilLib.getNull());
    public static final BlockGarlicBeacon garlic_beacon = (BlockGarlicBeacon)((Object)UtilLib.getNull());
    public static final BlockStairs castle_stairs_dark = (BlockStairs)UtilLib.getNull();
    public static final BlockStairs castle_stairs_dark_stone = (BlockStairs)UtilLib.getNull();
    public static final BlockStairs castle_stairs_purple = (BlockStairs)UtilLib.getNull();
    public static final BlockCastleSlab castle_slab = (BlockCastleSlab)((Object)UtilLib.getNull());
    public static final BlockCastleSlab castle_slab_double = (BlockCastleSlab)((Object)UtilLib.getNull());
    public static final BlockPedestal blood_pedestal = (BlockPedestal)((Object)UtilLib.getNull());
    public static final BlockGrinder blood_grinder = (BlockGrinder)((Object)UtilLib.getNull());
    public static final BlockSieve blood_sieve = (BlockSieve)((Object)UtilLib.getNull());
    public static final BlockTotemTop totem_top = (BlockTotemTop)((Object)UtilLib.getNull());
    public static final VampirismBlock totem_base = (VampirismBlock)((Object)UtilLib.getNull());
    private static final Map<String, String> OLD_TO_NEW_TILE_MAP = Maps.newHashMap();

    private static void registerTiles() {
        ModBlocks.registerTileEntity(TileTent.class, "tent", "VampirismTent");
        ModBlocks.registerTileEntity(TileCoffin.class, "coffin", "VampirismCoffin");
        ModBlocks.registerTileEntity(TileAltarInfusion.class, "altar_infusion", "VampirismAltarInfusion");
        ModBlocks.registerTileEntity(TileBloodContainer.class, "blood_container", "VampirismBloodContainer");
        ModBlocks.registerTileEntity(TileAltarInspiration.class, "altar_inspiration", "VampirismAltarInspiration");
        ModBlocks.registerTileEntity(TileSunscreenBeacon.class, "sunscreen_beacon", "VampirismSunscreenBeacon");
        ModBlocks.registerTileEntity(TileAlchemicalCauldron.class, "alchemical_cauldron", "VampirismAlchemicalCauldron");
        ModBlocks.registerTileEntity(TileGarlicBeacon.class, "garlic_beacon", "VampirismGarlicBeacon");
        ModBlocks.registerTileEntity(TilePedestal.class, "blood_pedestal");
        ModBlocks.registerTileEntity(TileGrinder.class, "grinder");
        ModBlocks.registerTileEntity(TileSieve.class, "sieve");
        ModBlocks.registerTileEntity(TileTotem.class, "totem");
    }

    private static void registerTileEntity(Class<? extends TileEntity> clazz, String id, String old) {
        ModBlocks.registerTileEntity(clazz, id);
        OLD_TO_NEW_TILE_MAP.put(old, "vampirism:" + id);
    }

    public static IFixableData getTileEntityIDFixer() {
        return new IFixableData(){

            @Nonnull
            public NBTTagCompound func_188217_a(@Nonnull NBTTagCompound compound) {
                String id = compound.func_74779_i("id");
                String newId = (String)OLD_TO_NEW_TILE_MAP.get(id);
                if (newId != null) {
                    compound.func_74778_a("id", newId);
                }
                return compound;
            }

            public int func_188216_a() {
                return 1;
            }
        };
    }

    private static void registerTileEntity(Class<? extends TileEntity> clazz, String id) {
        GameRegistry.registerTileEntity(clazz, (String)("vampirism:" + id));
    }

    static void registerItemBlocks(IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)new ItemMetaBlock(castle_block));
        ItemBlock itemBloodContainer = new ItemBlock((Block)blood_container);
        itemBloodContainer.setRegistryName(blood_container.getRegistryName());
        itemBloodContainer.func_77625_d(1);
        registry.register((IForgeRegistryEntry)itemBloodContainer);
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)block_blood_fluid));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(cursed_earth));
        registry.register((IForgeRegistryEntry)new ItemMetaBlock((Block)vampirism_flower));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)altar_infusion));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(altar_pillar));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(altar_tip));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(hunter_table));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(hunter_table2));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(church_altar));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)altar_inspiration));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(fire_place));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(weapon_table));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(blood_potion_table));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)sunscreen_beacon));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)alchemical_cauldron));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)garlic_beacon));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)castle_stairs_dark));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)castle_stairs_dark_stone));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)castle_stairs_purple));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)blood_pedestal));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)blood_grinder));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)blood_sieve));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock(totem_base));
        registry.register((IForgeRegistryEntry)ModBlocks.itemBlock((Block)totem_top));
        registry.register(new ItemSlab((Block)castle_slab, (BlockSlab)castle_slab, (BlockSlab)castle_slab_double).setRegistryName(castle_slab.getRegistryName()));
    }

    @Nonnull
    private static ItemBlock itemBlock(@Nonnull Block b) {
        ItemBlock item = new ItemBlock(b);
        item.setRegistryName(b.getRegistryName());
        return item;
    }

    static void registerBlocks(IForgeRegistry<Block> registry) {
        registry.register((IForgeRegistryEntry)new BlockFluidBlood(ModFluids.blood, "block_blood_fluid"));
        registry.register((IForgeRegistryEntry)new BlockFluidBlood(ModFluids.impure_blood, "block_impure_blood_fluid"));
        BlockCastleBlock castleBlock = new BlockCastleBlock();
        registry.register((IForgeRegistryEntry)castleBlock);
        registry.register((IForgeRegistryEntry)new VampirismFlower());
        registry.register((IForgeRegistryEntry)new BlockCursedEarth());
        registry.register((IForgeRegistryEntry)new BlockTent());
        registry.register((IForgeRegistryEntry)new BlockTentMain());
        registry.register((IForgeRegistryEntry)new BlockCoffin());
        registry.register((IForgeRegistryEntry)new BlockAltarInfusion());
        registry.register((IForgeRegistryEntry)new BlockAltarPillar());
        registry.register((IForgeRegistryEntry)new BlockAltarTip());
        registry.register((IForgeRegistryEntry)new BlockHunterTable(false));
        registry.register((IForgeRegistryEntry)new BlockHunterTable(true));
        registry.register((IForgeRegistryEntry)new BlockMedChair());
        registry.register((IForgeRegistryEntry)new BlockGarlic());
        registry.register((IForgeRegistryEntry)new BlockChurchAltar());
        registry.register((IForgeRegistryEntry)new BlockBloodContainer());
        registry.register((IForgeRegistryEntry)new BlockAltarInspiration());
        registry.register((IForgeRegistryEntry)new BlockFirePlace());
        registry.register((IForgeRegistryEntry)new BlockWeaponTable());
        registry.register((IForgeRegistryEntry)new BlockBloodPotionTable());
        registry.register((IForgeRegistryEntry)new BlockSunscreenBeacon());
        registry.register((IForgeRegistryEntry)new BlockAlchemicalFire());
        registry.register((IForgeRegistryEntry)new BlockAlchemicalCauldron());
        registry.register((IForgeRegistryEntry)new BlockGarlicBeacon());
        registry.register((IForgeRegistryEntry)new BlockCastleStairs(castleBlock, BlockCastleBlock.EnumType.DARK_BRICK, "dark"));
        registry.register((IForgeRegistryEntry)new BlockCastleStairs(castleBlock, BlockCastleBlock.EnumType.DARK_STONE, "dark_stone"));
        registry.register((IForgeRegistryEntry)new BlockCastleStairs(castleBlock, BlockCastleBlock.EnumType.PURPLE_BRICK, "purple"));
        registry.register((IForgeRegistryEntry)new BlockCastleSlab.Single());
        registry.register((IForgeRegistryEntry)new BlockCastleSlab.Double());
        registry.register((IForgeRegistryEntry)new BlockPedestal());
        registry.register((IForgeRegistryEntry)new BlockGrinder());
        registry.register((IForgeRegistryEntry)new BlockSieve());
        registry.register((IForgeRegistryEntry)new BlockTotemTop());
        registry.register((IForgeRegistryEntry)new BlockTotemBase());
        ModBlocks.registerTiles();
    }

    static void registerCraftingRecipes() {
    }

    static boolean fixMapping(RegistryEvent.MissingMappings.Mapping<Block> mapping) {
        return ModBlocks.checkMapping(mapping, mapping.key.func_110623_a(), false, new Block[]{alchemical_cauldron, alchemical_fire, altar_infusion, altar_inspiration, altar_pillar, altar_tip, blood_container, blood_potion_table, castle_block, church_altar, block_coffin, cursed_earth, fire_place, block_blood_fluid, garlic_beacon, hunter_table, med_chair, sunscreen_beacon, tent_main, vampirism_flower, weapon_table});
    }

    private static boolean checkMapping(RegistryEvent.MissingMappings.Mapping mapping, String name, boolean itemBlock, Block ... blocks) {
        for (Block b : blocks) {
            String newRegisteredName;
            String string = b instanceof VampirismBlock ? ((VampirismBlock)b).getRegisteredName() : (b instanceof VampirismBlockContainer ? ((VampirismBlockContainer)b).getRegisteredName() : (b instanceof VampirismFlower ? ((VampirismFlower)b).getRegisteredName() : (newRegisteredName = b instanceof BlockFluidBlood ? ((BlockFluidBlood)b).getRegisteredName() : null)));
            if (newRegisteredName == null) {
                VampirismMod.log.w("ModBlocks", "Unknown block class %s. Unable to determine new registered name during mapping fix", b.getClass());
                continue;
            }
            String oldRegisteredName = newRegisteredName.replaceAll("_", "");
            if (!oldRegisteredName.equals(name)) continue;
            if (itemBlock) {
                mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)b));
            } else {
                mapping.remap((IForgeRegistryEntry)b);
            }
            return true;
        }
        return false;
    }

    static boolean fixMappingItemBlock(RegistryEvent.MissingMappings.Mapping<Item> mapping) {
        String converted = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, mapping.key.func_110623_a());
        return ModBlocks.checkMapping(mapping, converted, true, new Block[]{alchemical_cauldron, altar_infusion, altar_inspiration, altar_pillar, altar_tip, blood_container, blood_potion_table, castle_block, church_altar, cursed_earth, fire_place, block_blood_fluid, garlic_beacon, hunter_table, sunscreen_beacon, vampirism_flower, weapon_table});
    }
}

