/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import com.google.common.collect.Lists;
import com.google.gson.JsonSyntaxException;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.items.ItemHunterCoat;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.HunterPlayerSpecialAttribute;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.tileentity.TileTotem;
import de.teamlapen.vampirism.util.Helper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderHandler {
    private static final ResourceLocation saturation1 = new ResourceLocation("vampirism:shaders/saturation1.json");
    private final Minecraft mc;
    private final int BLOOD_VISION_FADE_TICKS = 80;
    private final int VAMPIRE_BIOME_FADE_TICKS = 60;
    private final String TAG = "RenderHandler";
    private final List<EntityLivingBase> renderedEntitiesWithBlood = Lists.newLinkedList();
    private final List<EntityLivingBase> renderedEntitiesWithoutBlood = Lists.newLinkedList();
    private final List<EntityLivingBase> renderedEntitiesWithGarlicInfused = Lists.newLinkedList();
    private EntityBat entityBat;
    private int vampireBiomeTicks = 0;
    private boolean insideFog = false;
    private int bloodVisionTicks = 0;
    private int lastBloodVisionTicks = 0;
    private float vampireBiomeFogDistanceMultiplier = 1.0f;
    private Framebuffer bloodVisionFrameBuffer1;
    private Framebuffer bloodVisionFrameBuffer2;
    private Framebuffer bloodVisionFrameBuffer3;
    private ShaderGroup bloodVisionShader1;
    private ShaderGroup bloodVisionShader2;
    private ShaderGroup bloodVisionShader3;
    private ShaderGroup blurShader;
    private boolean bloodVisionShaderInit = false;
    private boolean bloodVision1Rendered = false;
    private boolean bloodVision2Rendered = false;
    private boolean bloodVision3Rendered = false;
    private boolean shaderWarning = false;
    private boolean showedShaderWarning = false;
    private boolean doSaturationShader = true;
    private int displayHeight;
    private int displayWidth;
    private boolean renderingBloodVision = false;
    private Shader blur1;
    private Shader blur2;
    private Shader blit0;
    private Shader blit1;
    private Shader blit2;
    private Shader blit3;
    private boolean hunterDisguiseEnabled;

    public RenderHandler(Minecraft mc) {
        this.mc = mc;
        this.displayHeight = mc.field_71440_d;
        this.displayWidth = mc.field_71443_c;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71441_e == null || this.mc.field_71439_g == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.lastBloodVisionTicks = this.bloodVisionTicks;
        VampirePlayer vampire = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g);
        if (vampire.getSpecialAttributes().blood_vision && !VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).isGettingSundamage()) {
            if (this.bloodVisionTicks < 80) {
                ++this.bloodVisionTicks;
            }
        } else {
            if (this.bloodVisionTicks > 0) {
                this.bloodVisionTicks -= 2;
                if (this.bloodVisionTicks <= 0) {
                    this.disableBloodVision();
                }
            }
            if (this.vampireBiomeTicks > 10 && this.bloodVisionTicks == 15) {
                this.bloodVisionTicks = 0;
                this.disableBloodVision();
            }
        }
        if (this.mc.field_71439_g.field_70173_aa % 10 == 0) {
            if (Configs.renderVampireForestFog && (Helper.isEntityInVampireBiome((Entity)this.mc.field_71439_g) || TileTotem.isInsideVampireAreaCached(this.mc.field_71441_e.field_73011_w.getDimension(), this.mc.field_71439_g.func_180425_c()))) {
                this.insideFog = true;
                this.vampireBiomeFogDistanceMultiplier = vampire.getSpecialAttributes().increasedVampireFogDistance ? 2.0f : 1.0f;
            } else {
                this.insideFog = false;
            }
        }
        if (this.insideFog) {
            if (this.vampireBiomeTicks < 60) {
                ++this.vampireBiomeTicks;
            }
        } else if (this.vampireBiomeTicks > 0) {
            --this.vampireBiomeTicks;
        }
        if (OpenGlHelper.func_153193_b() && this.doSaturationShader && this.mc.field_71439_g != null && this.mc.field_71439_g.func_70681_au().nextInt(10) == 3) {
            PotionEffect pe = this.mc.field_71439_g.func_70660_b(ModPotions.saturation);
            boolean active = pe != null && pe.func_76458_c() >= 2;
            EntityRenderer renderer = this.mc.field_71460_t;
            if (active && !renderer.func_147702_a()) {
                renderer.func_175069_a(saturation1);
            } else if (!active && renderer.func_147702_a() && renderer.func_147706_e().func_148022_b().equals(saturation1.toString())) {
                renderer.func_181022_b();
            }
        }
        if (this.shaderWarning) {
            this.shaderWarning = false;
            this.showedShaderWarning = true;
            this.mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Blood vision does not work on your hardware, because shaders are not supported"));
            this.mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("If you are running on recent hardware and use updated drivers, but this still shows up, please contact the author of Vampirism"));
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).getActionHandler().isActionActive(VampireActions.bat)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (this.bloodVisionTicks > 0 && !this.renderingBloodVision) {
            EntityLivingBase entity = event.getEntity();
            boolean flag = true;
            if (entity instanceof EntityPlayer && ItemHunterCoat.isFullyEquipped((EntityPlayer)entity)) {
                flag = false;
            }
            if (this.mc.field_71439_g.func_70068_e((Entity)entity) > (double)Balance.vps.BLOOD_VISION_DISTANCE_SQUARED) {
                flag = false;
            }
            if (flag) {
                IExtendedCreatureVampirism creature;
                IExtendedCreatureVampirism iExtendedCreatureVampirism = creature = entity instanceof EntityCreature ? ExtendedCreature.get((EntityCreature)entity) : null;
                if (creature != null && creature.getBlood() > 0 && !creature.hasPoisonousBlood()) {
                    this.renderedEntitiesWithBlood.add(event.getEntity());
                } else if (VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).getSpecialAttributes().garlic_blood_vision && (creature != null && creature.hasPoisonousBlood() || Helper.isHunter((Entity)entity))) {
                    this.renderedEntitiesWithGarlicInfused.add(event.getEntity());
                } else {
                    this.renderedEntitiesWithoutBlood.add(event.getEntity());
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingSpecialPre(RenderLivingEvent.Specials.Pre event) {
        EntityLivingBase entity = event.getEntity();
        if (entity instanceof EntityPlayer && HunterPlayer.get((EntityPlayer)entity).getSpecialAttributes().isDisguised() && entity.func_70068_e((Entity)this.mc.field_71439_g) > 4.0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        VampirePlayerSpecialAttributes vampireAttributes = VampirePlayer.get(player).getSpecialAttributes();
        HunterPlayerSpecialAttribute hunterAttributes = HunterPlayer.get(player).getSpecialAttributes();
        if (vampireAttributes.bat) {
            event.setCanceled(true);
            if (this.entityBat == null) {
                this.entityBat = new EntityBat(event.getEntity().func_130014_f_());
                this.entityBat.func_82236_f(false);
            }
            float parTick = event.getPartialRenderTick();
            Render renderer = this.mc.func_175598_ae().func_78713_a((Entity)this.entityBat);
            this.entityBat.field_70760_ar = player.field_70760_ar;
            this.entityBat.field_70761_aq = player.field_70761_aq;
            this.entityBat.field_70173_aa = player.field_70173_aa;
            this.entityBat.field_70125_A = player.field_70125_A;
            this.entityBat.field_70177_z = player.field_70177_z;
            this.entityBat.field_70759_as = player.field_70759_as;
            this.entityBat.field_70126_B = player.field_70126_B;
            this.entityBat.field_70127_C = player.field_70127_C;
            this.entityBat.field_70758_at = player.field_70758_at;
            this.entityBat.func_82142_c(player.func_82150_aj());
            float f1 = this.entityBat.field_70126_B + (this.entityBat.field_70177_z - this.entityBat.field_70126_B) * parTick;
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)parTick;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)parTick;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)parTick;
            Entity entity = this.mc.func_175606_aa();
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)parTick;
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)parTick;
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)parTick;
            this.mc.func_175598_ae().func_188391_a((Entity)this.entityBat, d0 - d3, d1 - d4, d2 - d5, f1, event.getPartialRenderTick(), false);
        } else if (hunterAttributes.isDisguised() && !player.equals((Object)this.mc.field_71439_g)) {
            double distSq = player.func_70068_e((Entity)this.mc.field_71439_g);
            if (distSq > (double)Balance.hpa.DISGUISE_DISTANCE_INVISIBLE_SQ) {
                event.setCanceled(true);
            } else {
                this.hunterDisguiseEnabled = true;
                this.enableProfile(Profile.HUNTER_DISGUISE, MathHelper.func_76131_a((float)((float)(distSq / (double)Balance.hpa.DISGUISE_DISTANCE_INVISIBLE_SQ * 25.0)), (float)0.0f, (float)1.0f) * hunterAttributes.getDisguiseProgress());
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        if (this.hunterDisguiseEnabled) {
            this.disableProfile(Profile.HUNTER_DISGUISE);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (this.mc.field_71441_e == null) {
            return;
        }
        if (this.bloodVisionTicks > 0) {
            this.renderBloodVisionOutlines(((float)this.bloodVisionTicks + (float)(this.bloodVisionTicks - this.lastBloodVisionTicks) * event.getPartialTicks()) / 80.0f, event.getPartialTicks());
        }
        if (this.vampireBiomeTicks > 0) {
            this.renderVampireBiomeFog(this.vampireBiomeTicks);
        }
        if (this.displayHeight != this.mc.field_71440_d || this.displayWidth != this.mc.field_71443_c) {
            this.displayHeight = this.mc.field_71440_d;
            this.displayWidth = this.mc.field_71443_c;
            if (OpenGlHelper.func_153193_b() && this.isRenderEntityOutlines()) {
                this.blurShader.func_148026_a(this.displayWidth, this.displayHeight);
                this.bloodVisionShader1.func_148026_a(this.displayWidth, this.displayHeight);
                this.bloodVisionShader2.func_148026_a(this.displayWidth, this.displayHeight);
                this.bloodVisionShader3.func_148026_a(this.displayWidth, this.displayHeight);
            }
        }
    }

    private void adjustBloodVisionShaders(float progress) {
        progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        this.blit0.func_148043_c().func_147991_a("ColorModulate").func_148081_a(1.0f - 0.8f * progress, 1.0f - 0.9f * progress, 1.0f - 0.7f * progress, 1.0f);
        this.blur1.func_148043_c().func_147991_a("Radius").func_148090_a((float)Math.round(10.0f * progress) / 1.0f);
        this.blur2.func_148043_c().func_147991_a("Radius").func_148090_a((float)Math.round(10.0f * progress) / 1.0f);
        this.blit1.func_148043_c().func_147991_a("ColorModulate").func_148081_a(1.0f, 0.1f, 0.1f, 1.0f * progress);
        this.blit2.func_148043_c().func_147991_a("ColorModulate").func_148081_a(0.1f, 0.1f, 0.2f, 0.7f * progress);
        this.blit3.func_148043_c().func_147991_a("ColorModulate").func_148081_a(0.1f, 0.1f, 1.0f, 1.0f * progress);
    }

    private void disableBloodVision() {
        this.renderedEntitiesWithoutBlood.clear();
        this.renderedEntitiesWithBlood.clear();
        this.renderedEntitiesWithGarlicInfused.clear();
    }

    private void disableProfile(Profile profile) {
        profile.clean();
    }

    private void enableProfile(Profile profile) {
        profile.apply(1.0f);
    }

    private void enableProfile(Profile profile, float progress) {
        progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        profile.apply(progress);
    }

    private boolean isRenderEntityOutlines() {
        return this.bloodVisionFrameBuffer1 != null && this.bloodVisionShader1 != null && this.bloodVisionFrameBuffer2 != null && this.bloodVisionShader2 != null && this.bloodVisionFrameBuffer3 != null && this.bloodVisionShader3 != null && this.mc.field_71439_g != null;
    }

    private void makeBloodVisionShader() {
        if (OpenGlHelper.field_148824_g) {
            if (ShaderLinkHelper.func_148074_b() == null) {
                ShaderLinkHelper.func_148076_a();
            }
            ResourceLocation resourcelocationOutline = new ResourceLocation("vampirism", "shaders/blood_vision_outline.json");
            ResourceLocation resourcelocationBlur = new ResourceLocation("vampirism", "shaders/blank.json");
            try {
                this.blurShader = new ShaderGroup(this.mc.func_110434_K(), this.mc.func_110442_L(), this.mc.func_147110_a(), resourcelocationBlur);
                Framebuffer swap = this.blurShader.func_177066_a("swap");
                this.blit0 = this.blurShader.func_148023_a("blit", swap, this.mc.func_147110_a());
                this.blur1 = this.blurShader.func_148023_a("blur", this.mc.func_147110_a(), swap);
                this.blur1.func_148043_c().func_147991_a("BlurDir").func_148087_a(1.0f, 0.0f);
                this.blur2 = this.blurShader.func_148023_a("blur", swap, this.mc.func_147110_a());
                this.blur2.func_148043_c().func_147991_a("BlurDir").func_148087_a(0.0f, 1.0f);
                this.bloodVisionShader1 = new ShaderGroup(this.mc.func_110434_K(), this.mc.func_110442_L(), this.mc.func_147110_a(), resourcelocationOutline);
                swap = this.bloodVisionShader1.func_177066_a("swap");
                this.bloodVisionFrameBuffer1 = this.bloodVisionShader1.func_177066_a("final");
                this.blit1 = this.bloodVisionShader1.func_148023_a("blit", swap, this.bloodVisionFrameBuffer1);
                this.bloodVisionShader2 = new ShaderGroup(this.mc.func_110434_K(), this.mc.func_110442_L(), this.mc.func_147110_a(), resourcelocationOutline);
                swap = this.bloodVisionShader2.func_177066_a("swap");
                this.bloodVisionFrameBuffer2 = this.bloodVisionShader2.func_177066_a("final");
                this.blit2 = this.bloodVisionShader2.func_148023_a("blit", swap, this.bloodVisionFrameBuffer2);
                this.bloodVisionShader3 = new ShaderGroup(this.mc.func_110434_K(), this.mc.func_110442_L(), this.mc.func_147110_a(), resourcelocationOutline);
                swap = this.bloodVisionShader3.func_177066_a("swap");
                this.bloodVisionFrameBuffer3 = this.bloodVisionShader3.func_177066_a("final");
                this.blit3 = this.bloodVisionShader3.func_148023_a("blit", swap, this.bloodVisionFrameBuffer3);
                this.blurShader.func_148026_a(this.mc.field_71443_c, this.mc.field_71440_d);
                this.bloodVisionShader1.func_148026_a(this.mc.field_71443_c, this.mc.field_71440_d);
                this.bloodVisionShader2.func_148026_a(this.mc.field_71443_c, this.mc.field_71440_d);
                this.bloodVisionShader3.func_148026_a(this.mc.field_71443_c, this.mc.field_71440_d);
            }
            catch (JsonSyntaxException | IOException ioexception) {
                VampirismMod.log.e("RenderHandler", ioexception, "Failed to load shader: {%s}", resourcelocationOutline);
                this.bloodVisionShader1 = null;
                this.bloodVisionFrameBuffer1 = null;
                this.bloodVisionShader2 = null;
                this.bloodVisionFrameBuffer2 = null;
                this.bloodVisionShader3 = null;
                this.bloodVisionFrameBuffer3 = null;
            }
        } else {
            this.bloodVisionShader1 = null;
            this.bloodVisionFrameBuffer1 = null;
            this.bloodVisionShader2 = null;
            this.bloodVisionFrameBuffer2 = null;
            this.bloodVisionShader3 = null;
            this.bloodVisionFrameBuffer3 = null;
        }
    }

    private void renderBloodVisionOutlines(float progress, float partialTicks) {
        if (!this.bloodVisionShaderInit) {
            this.makeBloodVisionShader();
            this.bloodVisionShaderInit = true;
        }
        if (!this.isRenderEntityOutlines()) {
            if (!this.showedShaderWarning) {
                this.shaderWarning = true;
            }
            return;
        }
        this.adjustBloodVisionShaders(progress);
        this.blurShader.func_148018_a(partialTicks);
        if (!this.renderedEntitiesWithBlood.isEmpty() || this.bloodVision1Rendered) {
            this.bloodVision1Rendered = this.renderEntityOutlines(this.renderedEntitiesWithBlood, this.bloodVisionShader1, this.bloodVisionFrameBuffer1, partialTicks);
        }
        this.renderedEntitiesWithBlood.clear();
        if (!this.renderedEntitiesWithoutBlood.isEmpty() || this.bloodVision2Rendered) {
            this.bloodVision2Rendered = this.renderEntityOutlines(this.renderedEntitiesWithoutBlood, this.bloodVisionShader2, this.bloodVisionFrameBuffer2, partialTicks);
        }
        this.renderedEntitiesWithoutBlood.clear();
        if (!this.renderedEntitiesWithGarlicInfused.isEmpty() || this.bloodVision3Rendered) {
            this.bloodVision3Rendered = this.renderEntityOutlines(this.renderedEntitiesWithGarlicInfused, this.bloodVisionShader3, this.bloodVisionFrameBuffer3, partialTicks);
        }
        this.renderedEntitiesWithGarlicInfused.clear();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        this.bloodVisionFrameBuffer1.func_178038_a(this.mc.field_71443_c, this.mc.field_71440_d, false);
        this.bloodVisionFrameBuffer2.func_178038_a(this.mc.field_71443_c, this.mc.field_71440_d, false);
        this.bloodVisionFrameBuffer3.func_178038_a(this.mc.field_71443_c, this.mc.field_71440_d, false);
        this.mc.func_147110_a().func_147610_a(false);
        GlStateManager.func_179084_k();
    }

    private boolean renderEntityOutlines(List<? extends Entity> entities, ShaderGroup shader, Framebuffer framebuffer, float partialTicks) {
        boolean flag;
        RenderManager renderManager = this.mc.func_175598_ae();
        this.mc.field_71441_e.field_72984_F.func_76320_a("bloodVision");
        framebuffer.func_147614_f();
        boolean bl = flag = !entities.isEmpty();
        if (flag) {
            this.renderingBloodVision = true;
            Entity entity = this.mc.func_175606_aa();
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            renderManager.func_178628_a(d3, d4, d5);
            this.mc.field_71460_t.func_180436_i();
            GlStateManager.func_179143_c((int)519);
            GlStateManager.func_179140_f();
            GlStateManager.func_179119_h();
            GlStateManager.func_179097_i();
            framebuffer.func_147610_a(false);
            RenderHelper.func_74518_a();
            renderManager.func_178632_c(true);
            for (Entity entity2 : entities) {
                renderManager.func_188388_a(entity2, partialTicks, false);
            }
            renderManager.func_178632_c(false);
            RenderHelper.func_74519_b();
            GlStateManager.func_179132_a((boolean)false);
            shader.func_148018_a(partialTicks);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179142_g();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179126_j();
            this.mc.field_71460_t.func_175072_h();
            this.renderingBloodVision = false;
        }
        this.mc.func_147110_a().func_147610_a(false);
        this.mc.field_71441_e.field_72984_F.func_76319_b();
        return flag;
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (this.vampireBiomeTicks == 0) {
            return;
        }
        float f = 60.0f / (float)this.vampireBiomeTicks / 1.5f;
        float fogStart = Math.min(event.getFarPlaneDistance() * 0.75f, 6.0f * (f *= this.vampireBiomeFogDistanceMultiplier));
        float fogEnd = Math.min(event.getFarPlaneDistance(), 50.0f * f);
        GlStateManager.func_179102_b((float)(event.getFogMode() == -1 ? 0.0f : fogStart));
        GlStateManager.func_179153_c((float)fogEnd);
    }

    private void renderVampireBiomeFog(int ticks) {
    }

    private static enum Profile {
        HUNTER_DISGUISE{

            @Override
            public void apply(float progress) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - progress * 0.8f));
                if (progress >= 1.0f) {
                    GlStateManager.func_179132_a((boolean)false);
                }
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            }

            @Override
            public void clean() {
                GlStateManager.func_179084_k();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        };


        public abstract void apply(float var1);

        public abstract void clean();
    }
}

