/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.block.PropertyStringUnlisted;
import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.tileentity.TileBloodContainer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockBloodContainer
extends VampirismBlockContainer {
    public static final IUnlistedProperty<Integer> FLUID_LEVEL = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"fluidLevel", (int)0, (int)14));
    public static final IUnlistedProperty<String> FLUID_NAME = new PropertyStringUnlisted("fluidName");
    public static final String regName = "blood_container";

    public BlockBloodContainer() {
        super(regName, Material.field_151592_s);
        this.func_149711_c(1.0f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileBloodContainer();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TileBloodContainer tile = (TileBloodContainer)(world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos));
        if (tile != null) {
            FluidStack fluid = tile.getTankInfo().fluid;
            float amount = fluid == null ? 0.0f : (float)fluid.amount / 900.0f;
            return extendedState.withProperty(FLUID_LEVEL, (Object)(amount > 0.0f && amount < 1.0f ? 1 : (int)amount)).withProperty(FLUID_NAME, (Object)(fluid == null ? "" : fluid.getFluid().getName()));
        }
        return extendedState.withProperty(FLUID_LEVEL, (Object)0).withProperty(FLUID_NAME, (Object)"");
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        super.func_149666_a(itemIn, items);
        ItemStack stack = new ItemStack((Block)this, 1);
        FluidStack fluid = new FluidStack(ModFluids.blood, 12600);
        stack.func_77983_a("fluid", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
        items.add((Object)stack);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack heldStack) {
        ItemStack stack = new ItemStack((Block)ModBlocks.blood_container, 1);
        FluidStack fluid = ((TileBloodContainer)te).getTankInfo().fluid;
        if (fluid != null && fluid.amount > 0) {
            stack.func_77983_a("fluid", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
        }
        BlockBloodContainer.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        if (!worldIn.field_72995_K && !(stack = playerIn.func_184586_b(hand)).func_190926_b() && FluidLib.hasFluidItemCap(stack)) {
            TileBloodContainer bloodContainer = (TileBloodContainer)worldIn.func_175625_s(pos);
            IFluidHandler source = (IFluidHandler)bloodContainer.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (playerIn.func_70093_af()) {
                FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)source, (int)Integer.MAX_VALUE, (EntityPlayer)playerIn, (boolean)true);
                if (result.isSuccess()) {
                    playerIn.func_184611_a(hand, result.getResult());
                }
            } else {
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)source, (int)Integer.MAX_VALUE, (EntityPlayer)playerIn, (boolean)true);
                if (result.isSuccess()) {
                    playerIn.func_184611_a(hand, result.getResult());
                }
            }
            return true;
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
            NBTTagCompound nbt = stack.func_77978_p().func_74775_l("fluid");
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            if (fluid == null) {
                VampirismMod.log.w("BloodContainer", "Failed to load fluid from item nbt %s", nbt);
            } else {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof TileBloodContainer) {
                    ((TileBloodContainer)tile).setFluidStack(fluid);
                }
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{FLUID_LEVEL, FLUID_NAME});
    }
}

