/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.part.PartTypeConnector;

public class PartTypeConnectorOmniDirectional
extends PartTypeConnector<PartTypeConnectorOmniDirectional, State> {
    public static LoadedGroups LOADED_GROUPS = new LoadedGroups();
    private static String NBT_KEY_ID = "omnidir-group-key";

    public PartTypeConnectorOmniDirectional(String name) {
        super(name, new PartRenderPosition(0.25f, 0.3125f, 0.625f, 0.625f));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public int getConsumptionRate(State state) {
        return 128;
    }

    @Override
    public State constructDefaultState() {
        return new State();
    }

    @Override
    public Class<? super PartTypeConnectorOmniDirectional> getPartTypeClass() {
        return PartTypeConnectorOmniDirectional.class;
    }

    @Override
    public ItemStack getItemStack(State state, boolean saveState) {
        ItemStack itemStack = super.getItemStack(state, saveState);
        if (state.hasConnectorId()) {
            NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)itemStack);
            tag.func_74768_a(NBT_KEY_ID, state.getGroupId());
        }
        return itemStack;
    }

    @Override
    public State getState(ItemStack itemStack) {
        State state = (State)super.getState(itemStack);
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null && tag.func_150297_b(NBT_KEY_ID, MinecraftHelpers.NBTTag_Types.NBTTagInt.ordinal())) {
            state.setGroupId(tag.func_74762_e(NBT_KEY_ID));
        } else {
            state.setGroupId(PartTypeConnectorOmniDirectional.generateGroupId());
        }
        return state;
    }

    @Override
    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onNetworkAddition(network, partNetwork, target, state);
        this.addPosition(network, state, target.getCenter());
    }

    @Override
    public void onPostRemoved(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onPostRemoved(network, partNetwork, target, state);
        this.removePosition(network, state, target.getCenter());
    }

    protected void addPosition(INetwork network, State state, PartPos pos) {
        if (!LOADED_GROUPS.isModifyingPositions() && !state.isAddedToGroup()) {
            state.setAddedToGroup(true);
            LOADED_GROUPS.addPosition(state.getGroupId(), pos, network.isInitialized());
        }
    }

    protected void removePosition(INetwork network, State state, PartPos pos) {
        if (!LOADED_GROUPS.isModifyingPositions() && state.isAddedToGroup() && state.hasConnectorId()) {
            state.setAddedToGroup(false);
            LOADED_GROUPS.removePosition(state.getGroupId(), pos, network.isInitialized());
        }
    }

    public static int generateGroupId() {
        return IntegratedDynamics.globalCounters.getNext("omnidir-connectors");
    }

    @Override
    public void loadTooltip(State state, List<String> lines) {
        super.loadTooltip(state, lines);
        lines.add(L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.monodirectionalconnector.group", (Object[])new Object[]{state.getGroupId()}));
    }

    @Override
    public void loadTooltip(ItemStack itemStack, List<String> lines) {
        super.loadTooltip(itemStack, lines);
        if (itemStack.func_77942_o()) {
            lines.add(L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.monodirectionalconnector.group", (Object[])new Object[]{itemStack.func_77978_p().func_74762_e(NBT_KEY_ID)}));
        }
    }

    protected IgnoredBlockStatus.Status getStatus(State state) {
        return state != null && state.hasConnectorId() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.INACTIVE;
    }

    @Override
    public IBlockState getBlockState(IPartContainer partContainer, EnumFacing side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (State)partContainer.getPartState(side) : null);
        return super.getBlockState(partContainer, side).func_177226_a((IProperty)IgnoredBlock.FACING, (Comparable)side).func_177226_a((IProperty)IgnoredBlockStatus.STATUS, (Comparable)((Object)status));
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() == this.getItem()) {
            int groupId = -1;
            int stackCount = 0;
            for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                NBTTagCompound tag;
                ItemStack slotStack = event.craftMatrix.func_70301_a(i);
                if (slotStack.func_190926_b()) continue;
                ++stackCount;
                if (groupId != -1 || slotStack.func_77973_b() != this.getItem() || !slotStack.func_77942_o() || !(tag = slotStack.func_77978_p()).func_150297_b(NBT_KEY_ID, MinecraftHelpers.NBTTag_Types.NBTTagInt.ordinal())) continue;
                groupId = tag.func_74762_e(NBT_KEY_ID);
            }
            if (stackCount == 1) {
                groupId = -1;
            }
            if (!MinecraftHelpers.isClientSide()) {
                if (groupId < 0) {
                    groupId = PartTypeConnectorOmniDirectional.generateGroupId();
                }
                NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)event.crafting);
                tag.func_74768_a(NBT_KEY_ID, groupId);
            }
        }
    }

    @Override
    public boolean onPartActivated(World world, BlockPos pos, State partState, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() || !partState.isEnabled()) {
            return false;
        }
        if (world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("parttype.parttypes.integrateddynamics.tooltip.monodirectionalconnector.group", new Object[]{partState.getGroupId()}), true);
        }
        return true;
    }

    public static class LoadedGroups {
        private Int2ObjectMap<Set<PartPos>> groupPositions = new Int2ObjectOpenHashMap();
        private boolean modifyingPositions = false;

        public void onStartedEvent(FMLServerStartedEvent event) {
            this.groupPositions.clear();
        }

        public Set<PartPos> getPositions(int group) {
            Set<PartPos> positions = (Set<PartPos>)this.groupPositions.get(group);
            return positions != null ? positions : Collections.emptySet();
        }

        protected void initNetworkGroup(Set<PartPos> positions) {
            for (PartPos position : positions) {
                if (!position.getPos().isLoaded()) continue;
                NetworkHelpers.initNetwork(position.getPos().getWorld(), position.getPos().getBlockPos(), position.getSide());
            }
        }

        public void addPosition(int group, PartPos pos, boolean initNetwork) {
            Set positions = (Set)this.groupPositions.get(group);
            if (positions == null) {
                positions = Sets.newTreeSet();
                this.groupPositions.put(group, (Object)positions);
            }
            positions.add(pos);
            if (initNetwork) {
                this.modifyingPositions = true;
                this.initNetworkGroup(positions);
                this.modifyingPositions = false;
            }
        }

        public void removePosition(int group, PartPos pos, boolean initNetwork) {
            Set positions = (Set)this.groupPositions.get(group);
            if (positions == null) {
                positions = Sets.newTreeSet();
                this.groupPositions.put(group, (Object)positions);
            }
            positions.remove(pos);
            if (initNetwork) {
                this.modifyingPositions = true;
                this.initNetworkGroup(positions);
                if (pos.getPos().isLoaded()) {
                    NetworkHelpers.initNetwork(pos.getPos().getWorld(), pos.getPos().getBlockPos(), pos.getSide());
                }
                this.modifyingPositions = false;
            }
        }

        public boolean isModifyingPositions() {
            return this.modifyingPositions;
        }
    }

    public static class State
    extends PartTypeConnector.State<PartTypeConnectorOmniDirectional> {
        private int groupId = -1;
        private boolean addedToGroup = false;

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            tag.func_74768_a(NBT_KEY_ID, this.groupId);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            this.groupId = tag.func_74762_e(NBT_KEY_ID);
        }

        @Override
        public Set<ISidedPathElement> getReachableElements() {
            if (this.hasConnectorId()) {
                TreeSet pathElements = Sets.newTreeSet();
                for (PartPos pos : LOADED_GROUPS.getPositions(this.getGroupId())) {
                    IPathElement pathElement;
                    if (pos.equals(this.getPartPos()) || (pathElement = (IPathElement)TileHelpers.getCapability((DimPos)pos.getPos(), (EnumFacing)pos.getSide(), PathElementConfig.CAPABILITY)) == null) continue;
                    pathElements.add(SidedPathElement.of(pathElement, pos.getSide()));
                }
                return pathElements;
            }
            return Collections.emptySet();
        }

        public int getGroupId() {
            return this.groupId;
        }

        public void setGroupId(int groupId) {
            this.groupId = groupId;
            this.sendUpdate();
        }

        public boolean hasConnectorId() {
            return this.groupId >= 0;
        }

        public boolean isAddedToGroup() {
            return this.addedToGroup;
        }

        public void setAddedToGroup(boolean addedToGroup) {
            this.addedToGroup = addedToGroup;
        }
    }
}

