/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class GuiConfigOverviewBase
extends GuiConfig {
    public GuiConfigOverviewBase(ModBase mod, GuiScreen parentScreen) {
        super(parentScreen, GuiConfigOverviewBase.getConfigElements(mod), mod.getModId(), false, false, L10NHelpers.localize("config." + mod.getModId(), mod.getModName()));
    }

    public abstract ModBase getMod();

    private static List<IConfigElement> getConfigElements(ModBase mod) {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        for (String category : mod.getConfigHandler().getCategories()) {
            list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(category, "config." + mod.getModId() + "." + category.replaceAll("\\s", ""), ExtendedCategoryEntry.class));
        }
        return list;
    }

    public static class ExtendedCategoryEntry
    extends GuiConfigEntries.CategoryEntry {
        private String category;

        public ExtendedCategoryEntry(GuiConfig config, GuiConfigEntries entries, IConfigElement element) {
            super(config, entries, element);
        }

        protected GuiScreen buildChildScreen() {
            ModBase mod = ((GuiConfigOverviewBase)this.owningScreen).getMod();
            this.category = this.configElement.getName();
            List elements = new ConfigElement(mod.getConfigHandler().getConfig().getCategory(this.category)).getChildElements();
            return new GuiConfig((GuiScreen)this.owningScreen, elements, this.owningScreen.modID, this.category, this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, L10NHelpers.localize("config.cyclopscore", mod.getModName()) + " > " + L10NHelpers.localize("config." + mod.getModId() + "." + this.category.replaceAll("\\s", ""), new Object[0]));
        }
    }
}

