/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.ModBlocks;
import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.biomes.decorators.data.FeatureType;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.decoration.WorldGenDesertRockGneiss;
import erebus.world.feature.decoration.WorldGenErebusLakesWithEdge;
import erebus.world.feature.decoration.WorldGenScorchedWood;
import erebus.world.feature.plant.WorldGenPricklyPairPatch;
import erebus.world.feature.structure.WorldGenAntlionLair;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class BiomeDecoratorVolcanicDesert
extends BiomeDecoratorBaseErebus {
    private final WorldGenScorchedWood genScorchedWood = new WorldGenScorchedWood();
    protected final WorldGenPricklyPairPatch genPricklyPair = new WorldGenPricklyPairPatch();
    private final WorldGenAntlionLair genAntlionLair = new WorldGenAntlionLair();
    private final WorldGenErebusLakesWithEdge genLavaLakes = new WorldGenErebusLakesWithEdge((Block)Blocks.field_150356_k, ModBlocks.VOLCANIC_ROCK);
    private final WorldGenDesertRockGneiss genRocks = new WorldGenDesertRockGneiss();

    @Override
    public void populate() {
        this.attempt = 0;
        while (this.attempt < 35) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.SAND, pos)) {
                this.genLavaLakes.func_180709_b(this.world, this.world.field_73012_v, pos.func_177984_a());
            }
            ++this.attempt;
        }
    }

    @Override
    public void decorate() {
        BlockPos pos;
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.world.func_180495_p(pos) == ModBlocks.UMBERSTONE.func_176223_P() && this.world.func_175623_d(pos.func_177977_b())) {
                this.world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
                this.world.func_189507_a(pos, Blocks.field_150356_k.func_176223_P(), this.rand);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 22) {
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.SAND, pos) && !this.world.func_175623_d(pos.func_177979_c(2))) {
                this.genScorchedWood.func_180709_b(this.world, this.rand, pos);
                if (this.rand.nextInt(4) != 0) break;
            }
            ++this.attempt;
        }
        if (this.rand.nextInt(20) == 0) {
            this.attempt = 0;
            while (this.attempt < this.rand.nextInt(4)) {
                this.xx = this.x + this.offsetXZ();
                this.yy = 25 + this.rand.nextInt(75);
                this.zz = this.z + this.offsetXZ();
                while (this.yy > 20) {
                    pos = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.SAND, pos)) {
                        this.genPricklyPair.func_180709_b(this.world, this.rand, pos.func_177984_a());
                        break;
                    }
                    --this.yy;
                }
                ++this.attempt;
            }
        }
        if (this.rand.nextInt(5) == 0) {
            for (int attempt = 0; attempt < 300 && !this.genAntlionLair.func_180709_b(this.world, this.rand, new BlockPos(this.x + 5 + this.rand.nextInt(6) + 8, 15 + this.rand.nextInt(35), this.z + 5 + this.rand.nextInt(6) + 8)); ++attempt) {
            }
        }
        if (this.rand.nextBoolean() && this.rand.nextBoolean()) {
            BlockPos pos2;
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 100;
            while (!(this.yy <= 20 || this.checkSurface(SurfaceType.SAND, pos2 = new BlockPos(this.xx, this.yy, this.zz)) && this.genRocks.func_180709_b(this.world, this.rand, pos2))) {
                --this.yy;
            }
        }
    }

    @Override
    public void generateFeature(FeatureType featureType) {
        if (featureType == FeatureType.RED_GEM) {
            this.attempt = 0;
            while (this.attempt < 10) {
                genRedGem.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), this.rand.nextInt(64), this.z + this.offsetXZ()));
                ++this.attempt;
            }
        } else {
            super.generateFeature(featureType);
        }
    }

    @Override
    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
        switch (oreType) {
            case COAL: {
                oreGen.setChance(0.0f);
                break;
            }
            case GOLD: {
                oreGen.setIterations(extraOres ? 1 : 2, extraOres ? 2 : 3);
                break;
            }
            case DIAMOND: {
                oreGen.setType(OreSettings.OreType.DIAMOND_ENCRUSTED).setChance(0.4f).setIterations(1, 2).setOreAmount(2).setY(5, 16);
                break;
            }
            case JADE: {
                oreGen.setIterations(0, 2);
                break;
            }
            case FOSSIL: {
                oreGen.setChance(0.25f).setIterations(0, 1);
            }
        }
    }
}

