/*
 * Decompiled with CFR 0.152.
 */
package erebus.world;

import erebus.core.handler.configs.ConfigHandler;
import erebus.world.WorldProviderErebus;
import erebus.world.biomes.BiomeBaseErebus;
import erebus.world.loot.IWeightProvider;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class SpawnerErebus {
    public static final SpawnerErebus INSTANCE = new SpawnerErebus();
    public static final int MAX_MOBS_PER_WORLD = 300;
    private boolean canSpawnHostiles;
    private boolean canSpawnAnimals;
    private Map<ChunkPos, Boolean> spawnChunks = new HashMap<ChunkPos, Boolean>(64);

    public static void onChunkPopulate(World world, Random rand, BiomeBaseErebus biome, int x, int z) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doMobSpawning")) {
            INSTANCE.runPopulationSpawning((WorldServer)world, rand, biome, x, z);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        WorldServer erebusWorld = DimensionManager.getWorld((int)ConfigHandler.INSTANCE.erebusDimensionID);
        if (erebusWorld != null && erebusWorld.func_82736_K().func_82766_b("doMobSpawning")) {
            this.runGradualSpawning(erebusWorld);
        }
    }

    private void prepare(WorldServer world) {
        WorldProviderErebus provider = (WorldProviderErebus)world.field_73011_w;
        this.canSpawnHostiles = provider.getCanSpawnHostiles();
        this.canSpawnAnimals = provider.getCanSpawnAnimals();
    }

    private void runGradualSpawning(WorldServer world) {
        this.prepare(world);
        if (!this.canSpawnHostiles && !this.canSpawnAnimals) {
            return;
        }
        this.spawnChunks.clear();
        List players = world.field_73010_i;
        int dist = 8;
        for (Object player : players) {
            int chunkX = ((EntityPlayer)player).field_70176_ah;
            int chunkZ = ((EntityPlayer)player).field_70164_aj;
            for (int px = -dist; px <= dist; ++px) {
                for (int pz = -dist; pz <= dist; ++pz) {
                    ChunkPos chunkPos = new ChunkPos(chunkX + px, chunkZ + pz);
                    if (px == -dist || px == dist || pz == -dist || pz == dist || Math.abs(px) <= 1 || Math.abs(pz) <= 1) {
                        if (this.spawnChunks.containsKey(chunkPos)) continue;
                        this.spawnChunks.put(chunkPos, false);
                        continue;
                    }
                    this.spawnChunks.put(chunkPos, true);
                }
            }
        }
        if (this.spawnChunks.isEmpty()) {
            return;
        }
        TObjectIntHashMap entityCount = new TObjectIntHashMap();
        for (Object e : world.field_72996_f) {
            if (!(e instanceof EntityLiving)) continue;
            entityCount.adjustOrPutValue(((Entity)e).getClass(), 1, 1);
        }
        int totalAmount = 0;
        for (int amt : entityCount.values()) {
            totalAmount += amt;
        }
        if (totalAmount >= Math.min(this.spawnChunks.size() >> 1, 300) / (world.func_175659_aa() == EnumDifficulty.PEACEFUL ? 2 : 1)) {
            return;
        }
        ArrayList<ChunkPos> arrayList = new ArrayList<ChunkPos>();
        for (Map.Entry<ChunkPos, Boolean> entry : this.spawnChunks.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            arrayList.add(entry.getKey());
        }
        Random rand = world.field_73012_v;
        int testedChunks = 3 + rand.nextInt(1 + 2 * world.func_175659_aa().func_151525_a());
        float yaw = 0.0f;
        Collections.shuffle(arrayList, rand);
        for (ChunkPos coords : arrayList) {
            int attempts = 0;
            int spawned = 0;
            while (attempts < 4 && spawned < 2) {
                SpawnEntry entry;
                int x = coords.field_77276_a * 16 + rand.nextInt(16);
                int z = coords.field_77275_b * 16 + rand.nextInt(16);
                int y = 10 + rand.nextInt(100);
                BlockPos blockCoord = new BlockPos(x, y, z);
                Biome biome = world.func_180494_b(blockCoord);
                if (!(biome instanceof BiomeBaseErebus) || (entry = ((BiomeBaseErebus)biome).getRandomSpawnGradual(rand)) == null) break;
                ++attempts;
                if (entry.isHostile && !this.canSpawnHostiles || !entry.isHostile && !this.canSpawnAnimals || rand.nextFloat() < biome.func_76741_f() || entry.worldLimit != -1 && entityCount.get(entry.mobClass) >= entry.worldLimit) continue;
                EntityLiving entity = null;
                int spawnGroup = entry.minGroupSize + rand.nextInt(entry.maxGroupSize - entry.minGroupSize + 1);
                boolean continueSpawning = true;
                boolean coordsFinal = false;
                int maxPosAttempts = 20 + spawnGroup * 2;
                while (continueSpawning) {
                    for (int posAttempts = 0; posAttempts < maxPosAttempts; ++posAttempts) {
                        float fx = (float)(x + rand.nextInt(12) - 6) + 0.5f;
                        float fy = y + rand.nextInt(2) - 1;
                        float fz = (float)(z + rand.nextInt(12) - 6) + 0.5f;
                        if ((entry.blockBelow == null && world.func_180495_p(new BlockPos((int)fx, (int)fy - 1, (int)fz)).func_185915_l() || world.func_180495_p(new BlockPos((int)fx, (int)fy - 1, (int)fz)) == entry.blockBelow) && world.func_184137_a((double)fx, (double)fy, (double)fz, 24.0, false) == null) {
                            if (!coordsFinal) {
                                coordsFinal = true;
                                posAttempts = 10;
                            }
                            if (entity == null) {
                                entity = entry.createEntity((World)world);
                                yaw = rand.nextFloat() * 360.0f;
                            }
                            if (entity == null) {
                                continueSpawning = false;
                                --spawned;
                                break;
                            }
                            entity.func_70012_b((double)fx, (double)fy, (double)fz, yaw, 0.0f);
                            if (entity.func_70601_bi()) {
                                world.func_72838_d((Entity)entity);
                                entity = null;
                                if (--spawnGroup > 0) break;
                                continueSpawning = false;
                                break;
                            }
                        }
                        if (!coordsFinal) {
                            x = coords.field_77276_a * 16 + rand.nextInt(16);
                            z = coords.field_77275_b * 16 + rand.nextInt(16);
                            y = 20 + rand.nextInt(80);
                        }
                        if (posAttempts != maxPosAttempts - 1) continue;
                        continueSpawning = false;
                    }
                    ++spawned;
                }
            }
            if (--testedChunks > 0) continue;
            break;
        }
    }

    private void runPopulationSpawning(WorldServer world, Random rand, BiomeBaseErebus biome, int x, int z) {
        this.prepare(world);
    }

    private SpawnerErebus() {
    }

    public static final class SpawnEntry
    implements IWeightProvider {
        private final Constructor<? extends EntityLiving> mobConstructor;
        protected final Class<? extends EntityLiving> mobClass;
        protected final short weight;
        protected final boolean isHostile;
        protected byte minGroupSize = 1;
        protected byte maxGroupSize = 1;
        protected int worldLimit = 10;
        protected Block blockBelow = null;

        public SpawnEntry(Class<? extends EntityLiving> mobClass, int weight) {
            this.mobClass = mobClass;
            this.weight = (short)weight;
            this.isHostile = IMob.class.isAssignableFrom(mobClass);
            try {
                this.mobConstructor = mobClass.getConstructor(World.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find constructor (World) of mob " + mobClass.getSimpleName(), e);
            }
        }

        public SpawnEntry setGroupSize(int minGroupSize, int maxGroupSize) {
            this.minGroupSize = (byte)minGroupSize;
            this.maxGroupSize = (byte)maxGroupSize;
            return this;
        }

        public SpawnEntry setWorldLimit(int mobAmountLimit) {
            this.worldLimit = mobAmountLimit;
            return this;
        }

        public SpawnEntry setBlockBelow(Block block) {
            this.blockBelow = block;
            return this;
        }

        @Override
        public short getWeight() {
            return this.weight;
        }

        public EntityLiving createEntity(World world) {
            try {
                return this.mobConstructor.newInstance(world);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

