/*
 * Decompiled with CFR 0.152.
 */
package erebus.recipes;

import erebus.core.helper.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class SmoothieMakerRecipe {
    private static final List<SmoothieMakerRecipe> recipes = new ArrayList<SmoothieMakerRecipe>();
    private final ItemStack output;
    private final ItemStack container;
    private final FluidStack[] fluids;
    private final Object[] input;

    public static void addRecipe(ItemStack output, ItemStack container, FluidStack fluid, Object ... input) {
        SmoothieMakerRecipe.addRecipe(output, container, new FluidStack[]{fluid}, input);
    }

    public static void addRecipe(ItemStack output, ItemStack container, FluidStack[] fluids, Object ... input) {
        recipes.add(new SmoothieMakerRecipe(output, container, fluids, input));
    }

    public static void addRecipe(ItemStack output, ItemStack container, Fluid fluid, Object ... input) {
        SmoothieMakerRecipe.addRecipe(output, container, new Fluid[]{fluid}, input);
    }

    public static void addRecipe(ItemStack output, ItemStack container, Fluid[] fluids, Object ... input) {
        FluidStack[] stacks = new FluidStack[fluids.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = new FluidStack(fluids[i], 1000);
        }
        SmoothieMakerRecipe.addRecipe(output, container, stacks, input);
    }

    public static ItemStack getOutput(ItemStack container, IFluidTank tank0, IFluidTank tank1, IFluidTank tank2, IFluidTank tank3, ItemStack ... input) {
        SmoothieMakerRecipe recipe = SmoothieMakerRecipe.getRecipe(container, tank0, tank1, tank2, tank3, input);
        return recipe != null ? recipe.getOutput() : ItemStack.field_190927_a;
    }

    public static SmoothieMakerRecipe getRecipe(ItemStack container, IFluidTank tank0, IFluidTank tank1, IFluidTank tank2, IFluidTank tank3, ItemStack ... input) {
        for (SmoothieMakerRecipe recipe : recipes) {
            if (!recipe.matches(container, tank0, tank1, tank2, tank3, input)) continue;
            return recipe;
        }
        return null;
    }

    public static List<SmoothieMakerRecipe> getRecipeList() {
        return Collections.unmodifiableList(recipes);
    }

    private SmoothieMakerRecipe(ItemStack output, ItemStack container, FluidStack[] fluids, Object ... input) {
        this.output = output.func_77946_l();
        this.container = container;
        this.fluids = fluids;
        this.input = new Object[input.length];
        if (input.length > 4) {
            throw new IllegalArgumentException("Input must be 1 to 4.");
        }
        if (fluids.length > 4) {
            throw new IllegalArgumentException("Fluids must be 1 to 4.");
        }
        for (int c = 0; c < input.length; ++c) {
            if (input[c] instanceof ItemStack) {
                this.input[c] = ((ItemStack)input[c]).func_77946_l();
                continue;
            }
            if (input[c] instanceof String) {
                this.input[c] = OreDictionary.getOres((String)((String)input[c]));
                continue;
            }
            throw new IllegalArgumentException("Input must be an ItemStack or an OreDictionary name");
        }
    }

    public Object[] getInputs() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public ItemStack getContainer() {
        return this.container.func_77946_l();
    }

    public boolean matches(ItemStack container, IFluidTank tank0, IFluidTank tank1, IFluidTank tank2, IFluidTank tank3, ItemStack ... stacks) {
        if (!container.func_190926_b() && !this.areStacksTheSame(container, this.container) && container.func_190916_E() == this.container.func_190916_E()) {
            return false;
        }
        for (Object input : this.input) {
            block6: {
                for (int i = 0; i < stacks.length; ++i) {
                    if (stacks[i].func_190926_b() || !this.areStacksTheSame(input, stacks[i])) {
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            stacks[i] = ItemStack.field_190927_a;
        }
        block2: for (FluidStack fluid : this.fluids) {
            for (IFluidTank tank : new IFluidTank[]{tank0, tank1, tank2, tank3}) {
                if (tank.getFluidAmount() >= fluid.amount && tank.getFluid().isFluidEqual(fluid)) continue block2;
            }
            return false;
        }
        return true;
    }

    public boolean isPartOfInput(ItemStack ingredient) {
        for (Object i : this.input) {
            if (!this.areStacksTheSame(i, ingredient)) continue;
            return true;
        }
        return this.areStacksTheSame(this.container, ingredient);
    }

    public FluidStack[] getFluids() {
        FluidStack[] fluids = new FluidStack[this.fluids.length];
        for (int i = 0; i < fluids.length; ++i) {
            fluids[i] = this.fluids[i].copy();
        }
        return fluids;
    }

    public boolean areStacksTheSame(Object obj, ItemStack target) {
        if (obj instanceof ItemStack) {
            return Utils.areStacksTheSame((ItemStack)obj, target, false);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            for (ItemStack stack : list) {
                if (!Utils.areStacksTheSame(stack, target, false)) continue;
                return true;
            }
        }
        return false;
    }
}

