/*
 * Decompiled with CFR 0.152.
 */
package erebus.items;

import erebus.ModTabs;
import erebus.items.IShieldType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemErebusShield
extends ItemShield {
    private IShieldType shieldType;

    public ItemErebusShield() {
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return stack.func_77973_b().func_77661_b(stack) == EnumAction.BLOCK && entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_77661_b(stack) == EnumAction.BLOCK) {
            return super.func_77659_a(world, player, hand);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public IShieldType getShieldType() {
        return this.shieldType;
    }

    public void setShieldType(IShieldType shieldType) {
        this.shieldType = shieldType;
        this.func_77656_e(shieldType.getDurability());
    }

    public CreativeTabs func_77640_w() {
        return ModTabs.GEAR;
    }

    public String func_77653_i(ItemStack stack) {
        return new TextComponentTranslation(this.func_77657_g(stack) + ".name", new Object[0]).func_150254_d().trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        this.shieldType.addInformation(stack, world, list, flag);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        this.shieldType.onUpdate(this, stack, world, entity, slot, selected);
    }

    public boolean isRepairable() {
        return !this.shieldType.getRepairItem().func_190926_b();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return !repair.func_190926_b() && ItemStack.func_179545_c((ItemStack)repair, (ItemStack)this.shieldType.getRepairItem());
    }

    public boolean damageShield(int toDamage, ItemStack stack, EntityLivingBase entity) {
        int damage = stack.func_77952_i() + toDamage;
        if (damage >= this.getMaxDamage(stack)) {
            stack.func_190918_g(1);
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                player.func_71029_a(StatList.func_188059_c((Item)stack.func_77973_b()));
            }
            if (stack.func_190916_E() < 0) {
                stack.func_190920_e(0);
            }
        } else {
            stack.func_77964_b(damage);
        }
        return true;
    }

    public boolean repairShield(int toRepair, ItemStack stack) {
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(Math.max(0, stack.func_77952_i() - toRepair));
            return true;
        }
        return false;
    }
}

