/*
 * Decompiled with CFR 0.152.
 */
package erebus.items;

import erebus.ModItems;
import erebus.ModSounds;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.items.ItemMaterials;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemErebusFood
extends ItemFood
implements ModItems.ISubItemsItem {
    public ItemErebusFood() {
        super(3, 0.5f, false);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(ModTabs.ITEMS);
    }

    public PotionEffect getPotionEffect(ItemStack is, World world, EntityPlayer player) {
        switch (EnumFoodType.values()[is.func_77952_i()]) {
            case BEETLE_LARVA_RAW: {
                return new PotionEffect(MobEffects.field_76431_k, 300, 2);
            }
            case MELONADE_SPARKLY: {
                return new PotionEffect(MobEffects.field_76428_l, 200, 0);
            }
            case LARVAE_ON_STICK: {
                return new PotionEffect(MobEffects.field_76431_k, 100, 1);
            }
            case TITAN_CHOP_COOKED: {
                return new PotionEffect(MobEffects.field_76420_g, 600, 1);
            }
        }
        return null;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        switch (EnumFoodType.values()[stack.func_77952_i()]) {
            case MELONADE_SPARKLY: 
            case MELONADE: {
                return EnumAction.DRINK;
            }
        }
        return EnumAction.EAT;
    }

    public int func_150905_g(ItemStack stack) {
        return EnumFoodType.values()[stack.func_77952_i()].getHealAmount();
    }

    public float func_150906_h(ItemStack stack) {
        return EnumFoodType.values()[stack.func_77952_i()].getSaturationModifier();
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            EnumFoodType type = EnumFoodType.values()[stack.func_77952_i()];
            player.func_71024_bL().func_151686_a((ItemFood)this, stack);
            SoundEvent sound = type == EnumFoodType.CABBAGE ? ModSounds.CABBAGE_FART : SoundEvents.field_187739_dZ;
            float volume = type == EnumFoodType.CABBAGE ? 1.0f : 0.5f;
            world.func_184133_a(null, player.func_180425_c(), sound, SoundCategory.PLAYERS, volume, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.func_77849_c(stack, world, player);
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
        stack.func_190918_g(1);
        return this.hasContainerItem(stack) ? this.getContainerItem(stack) : stack;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        PotionEffect effect = this.getPotionEffect(stack, world, player);
        if (!world.field_72995_K && effect != null) {
            player.func_70690_d(effect);
        }
        if (!world.field_72995_K && stack.func_77952_i() == EnumFoodType.PRICKLY_PEAR_RAW.ordinal()) {
            player.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.ITEMS) {
            for (EnumFoodType type : EnumFoodType.values()) {
                list.add((Object)type.createStack(1));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77952_i();
        meta = Math.min(Math.max(meta, 0), EnumFoodType.values().length - 1);
        return super.func_77658_a() + "." + EnumFoodType.values()[meta].name().toLowerCase();
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (stack.func_77952_i() >= EnumFoodType.values().length) {
            return ItemStack.field_190927_a;
        }
        switch (EnumFoodType.values()[stack.func_77952_i()]) {
            case LARVAE_ON_STICK: {
                return new ItemStack(Items.field_151055_y);
            }
            case BAMBOO_SOUP: {
                return new ItemStack(Items.field_151054_z);
            }
            case MELONADE_SPARKLY: 
            case MELONADE: {
                return ItemMaterials.EnumErebusMaterialsType.SMOOTHIE_GLASS.createStack();
            }
            case TITAN_STEW_COOKED: {
                return ItemMaterials.EnumErebusMaterialsType.STEW_POT.createStack();
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getContainerItem(stack) != ItemStack.field_190927_a;
    }

    public int getItemStackLimit(ItemStack stack) {
        return !this.hasContainerItem(stack) ? 64 : 1;
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumFoodType type : EnumFoodType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    public static enum EnumFoodType implements IErebusEnum
    {
        BEETLE_LARVA_RAW(1, 0.1f),
        BEETLE_LARVA_COOKED(3, 0.4f),
        GRASSHOPPER_LEG_RAW(1, 0.1f),
        GRASSHOPPER_LEG_COOKED(4, 0.4f),
        TARANTULA_LEG_RAW(1, 0.1f),
        TARANTULA_LEG_COOKED(5, 0.4f),
        BAMBOO_SOUP(4, 0.3f),
        MELONADE(3, 0.2f),
        MELONADE_SPARKLY(5, 0.4f),
        LARVAE_ON_STICK(9, 0.5f),
        HONEY_SANDWICH(6, 0.6f),
        DARK_FRUIT(2, 0.3f),
        TITAN_CHOP_RAW(4, 0.3f),
        TITAN_CHOP_COOKED(8, 0.8f),
        SWAMP_BERRIES(1, 0.1f),
        CABBAGE(1, 0.3f),
        TITAN_STEW_COOKED(20, 4.0f),
        PRICKLY_PEAR_RAW(3, 0.3f),
        PRICKLY_PEAR_COOKED(4, 0.5f),
        DARK_FRUIT_PIE(8, 0.3f);

        private final int healAmount;
        private final float saturationModifier;

        private EnumFoodType(int healAmount, float saturationModifier) {
            this.healAmount = healAmount;
            this.saturationModifier = saturationModifier;
        }

        public float getSaturationModifier() {
            return this.saturationModifier;
        }

        public int getHealAmount() {
            return this.healAmount;
        }

        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModItems.EREBUS_FOOD, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

