/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity.ai;

import erebus.core.helper.Spiral;
import erebus.core.helper.Utils;
import erebus.entity.EntityBlackAnt;
import java.awt.Point;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public abstract class EntityAIAntsBlock
extends EntityAIBase {
    private static final int CHECKS_PER_TICK = 3;
    private final int EAT_SPEED;
    protected final EntityLiving entity;
    private final int maxGrowthMetadata;
    private final IBlockState blockState;
    private final ItemStack seed;
    private boolean hasTarget;
    public int cropX;
    public int cropY;
    public int cropZ;
    private int spiralIndex;
    private int eatTicks;
    private static final List<Point> spiral = new Spiral(8, 8).spiral();

    public EntityAIAntsBlock(EntityLiving entity, IBlockState state, int maxGrowthMetadata, ItemStack seed, double moveSpeed, int eatSpeed) {
        this.entity = entity;
        this.maxGrowthMetadata = maxGrowthMetadata;
        this.blockState = state;
        this.seed = seed;
        this.hasTarget = false;
        this.spiralIndex = 0;
        this.EAT_SPEED = eatSpeed * 20;
    }

    public EntityAIAntsBlock(EntityAnimal entity, IBlockState state, int maxGrowthMetadata, float moveSpeed, int eatSpeed) {
        this((EntityLiving)entity, state, maxGrowthMetadata, null, moveSpeed, eatSpeed);
    }

    public boolean func_75250_a() {
        return true;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70631_g_();
    }

    public void func_75246_d() {
        EntityBlackAnt blackAnt = (EntityBlackAnt)this.entity;
        if (!this.func_75253_b()) {
            return;
        }
        int xCoord = blackAnt.getDropPointX();
        int yCoord = blackAnt.getDropPointY();
        int zCoord = blackAnt.getDropPointZ();
        for (int i = 0; i < 3; ++i) {
            boolean flag;
            if (!this.hasTarget) {
                this.increment();
                Point p = this.getNextPoint();
                for (int y = -2; y < 1; ++y) {
                    if (!this.canEatBlock(this.entity.func_130014_f_().func_180495_p(new BlockPos(xCoord + p.x, yCoord + y, zCoord + p.y)))) continue;
                    this.cropX = xCoord + p.x;
                    this.cropY = yCoord + y;
                    this.cropZ = zCoord + p.y;
                    this.hasTarget = true;
                }
                continue;
            }
            if (!this.isEntityReady()) continue;
            this.moveToLocation();
            this.entity.func_70671_ap().func_75650_a((double)this.cropX + 0.5, (double)this.cropY + 0.5, (double)this.cropZ + 0.5, 30.0f, 8.0f);
            AxisAlignedBB blockbounds = this.getBlockAABB(this.cropX, this.cropY, this.cropZ);
            boolean bl = flag = this.entity.func_174813_aQ().field_72337_e >= blockbounds.field_72338_b && this.entity.func_174813_aQ().field_72338_b <= blockbounds.field_72337_e && this.entity.func_174813_aQ().field_72336_d >= blockbounds.field_72340_a && this.entity.func_174813_aQ().field_72340_a <= blockbounds.field_72336_d && this.entity.func_174813_aQ().field_72334_f >= blockbounds.field_72339_c && this.entity.func_174813_aQ().field_72339_c <= blockbounds.field_72334_f;
            if (flag && this.canEatBlock(this.getTargetBlock())) {
                this.prepareToEat();
                ++this.eatTicks;
                if (!this.canEatBlock(this.getTargetBlock())) {
                    this.eatingInterupted();
                    this.hasTarget = false;
                    this.eatTicks = 0;
                    return;
                }
                if (this.EAT_SPEED <= this.eatTicks) {
                    if (this.seed != null) {
                        Utils.dropStack(this.entity.func_130014_f_(), new BlockPos(this.cropX, this.cropY, this.cropZ), this.seed.func_77946_l());
                    }
                    this.hasTarget = false;
                    this.eatTicks = 0;
                    this.afterEaten();
                    return;
                }
            }
            if ((flag || this.eatTicks <= 0) && !this.entity.func_130014_f_().func_175623_d(new BlockPos(this.cropX, this.cropY, this.cropZ))) continue;
            this.eatingInterupted();
            this.hasTarget = false;
            this.eatTicks = 0;
            return;
        }
    }

    private void increment() {
        ++this.spiralIndex;
        if (this.spiralIndex >= spiral.size()) {
            this.spiralIndex = 0;
        }
    }

    private Point getNextPoint() {
        return spiral.get(this.spiralIndex);
    }

    public IBlockState getTargetBlock() {
        IBlockState state = this.entity.func_130014_f_().func_180495_p(new BlockPos(this.cropX, this.cropY, this.cropZ));
        return state;
    }

    protected boolean canEatBlock(IBlockState state) {
        return state == this.blockState && state.func_177230_c().func_176201_c(state) == this.maxGrowthMetadata && state.func_177230_c() != Blocks.field_150350_a;
    }

    protected abstract boolean isEntityReady();

    protected abstract void moveToLocation();

    protected abstract void prepareToEat();

    protected abstract void eatingInterupted();

    protected abstract void afterEaten();

    protected AxisAlignedBB getBlockAABB(int x, int y, int z) {
        return new AxisAlignedBB((double)this.cropX, (double)this.cropY, (double)this.cropZ, (double)this.cropX + 1.0, (double)this.cropY + 1.0, (double)this.cropZ + 1.0);
    }
}

