/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.entity.EntityMoneySpider;
import erebus.entity.ai.EntityAITarantulaMinibossAttack;
import erebus.network.client.PacketParticle;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityTarantulaMiniboss
extends EntityMob {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_10).func_186741_a(false);
    private static final DataParameter<Byte> SKIN_TYPE = EntityDataManager.func_187226_a(EntityTarantulaMiniboss.class, (DataSerializer)DataSerializers.field_187191_a);
    public int deathTicks;

    public EntityTarantulaMiniboss(World world) {
        super(world);
        this.func_70105_a(4.0f, 1.2f);
        this.field_70728_aV = 100;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN_TYPE, (Object)1);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITarantulaMinibossAttack((EntityCreature)this, EntityPlayer.class, 0.3, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 300.0 : 300.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 8.0 : 8.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.9);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70658_aO() {
        return 8;
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.getFancyRenderOverlay()) {
            this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)0);
        }
        if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.func_110143_aJ() > 0.0f && this.func_70638_az() != null) {
            float distance = (float)this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
            this.forceCollideWithPlayer(this.func_70638_az(), distance);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    protected void func_70609_aI() {
        int i;
        int j;
        ++this.deathTicks;
        if (this.deathTicks % 25 == 1) {
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), this.func_184615_bR(), SoundCategory.HOSTILE, 1.0f, 0.1f);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), SoundEvents.field_187821_fM, SoundCategory.HOSTILE, 1.0f, 0.1f);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), SoundEvents.field_187555_bJ, SoundCategory.HOSTILE, 1.0f, 0.1f);
        }
        if (this.deathTicks >= 180 && this.deathTicks <= 200 && !this.func_130014_f_().field_72995_K) {
            Erebus.NETWORK_WRAPPER.sendToAll((IMessage)new PacketParticle(PacketParticle.ParticleType.BOSS_DEATH, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
        }
        if (!this.func_130014_f_().field_72995_K && this.deathTicks > 150 && this.deathTicks % 5 == 0) {
            for (i = 1000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
        this.func_70091_d(MoverType.SELF, 0.0, 0.31000000014901163, 0.0);
        this.field_70761_aq = this.field_70760_ar += 0.05f;
        this.field_70721_aZ = 0.5f;
        if (this.deathTicks == 200 && !this.func_130014_f_().field_72995_K) {
            for (i = 2000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            this.func_130014_f_().func_175656_a(this.func_180425_c(), ModBlocks.TARANTULA_EGG.func_176223_P());
            Utils.dropStackNoRandom(this.func_130014_f_(), this.func_180425_c().func_177981_b(2), new ItemStack(ModItems.SPIDER_T_SHIRT));
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_110143_aJ() > this.func_110138_aP() / 2.0f && !(source instanceof EntityDamageSourceIndirect)) {
            return false;
        }
        if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && source instanceof EntityDamageSourceIndirect) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLiving) {
                int duration = 0;
                if (this.func_130014_f_().func_175659_aa().ordinal() > EnumDifficulty.EASY.ordinal() && this.field_70146_Z.nextInt(19) == 0) {
                    if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL) {
                        duration = 5;
                    } else if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
                        duration = 10;
                    }
                }
                if (duration > 0) {
                    ((EntityLiving)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.func_130014_f_().field_73012_v.nextInt(100) == 0) {
            EntityMoneySpider moneyspider = new EntityMoneySpider(this.func_130014_f_());
            moneyspider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            moneyspider.func_180482_a(difficulty, null);
            this.func_130014_f_().func_72838_d((Entity)moneyspider);
            moneyspider.func_184220_m((Entity)this);
        }
        if (livingdata == null) {
            Potion potion;
            livingdata = new EntitySpider.GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((EntitySpider.GroupData)livingdata).func_111104_a(this.field_70170_p.field_73012_v);
            }
            if (livingdata instanceof EntitySpider.GroupData && (potion = ((EntitySpider.GroupData)livingdata).field_188478_a) != null) {
                this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
            }
        }
        return livingdata;
    }

    public boolean getFancyRenderOverlay() {
        return (Byte)this.field_70180_af.func_187225_a(SKIN_TYPE) == 1;
    }

    public void forceCollideWithPlayer(EntityLivingBase entity, float distance) {
        if (distance > 1.0f && distance < 8.0f && this.field_70122_E) {
            this.func_70671_ap().func_75651_a((Entity)entity, 30.0f, 30.0f);
            this.func_70625_a((Entity)entity, 30.0f, 30.0f);
            double distanceX = entity.field_70165_t - this.field_70165_t;
            double distanceZ = entity.field_70161_v - this.field_70161_v;
            float squareRoot = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
            this.field_70159_w = distanceX / (double)squareRoot * 0.5 * 0.300000011920929 + this.field_70159_w * 0.10000000298023223;
            this.field_70179_y = distanceZ / (double)squareRoot * 0.5 * 0.300000011920929 + this.field_70179_y * 0.10000000298023223;
            this.field_70181_x = 0.0;
        }
    }

    public void func_70024_g(double x, double y, double z) {
        if (this.func_110143_aJ() > 150.0f) {
            this.field_70159_w = 0.0;
            this.field_70181_x += y;
            this.field_70179_y = 0.0;
            this.field_70160_al = false;
        } else {
            this.field_70159_w += x;
            this.field_70181_x += y;
            this.field_70179_y += z;
            this.field_70160_al = true;
        }
    }

    public void spawnBlamParticles() {
        if (!this.func_130014_f_().field_72995_K) {
            Erebus.NETWORK_WRAPPER.sendToAll((IMessage)new PacketParticle(PacketParticle.ParticleType.TARANTULA_BLAM, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }
}

