/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.core.handler.configs.ConfigHandler;
import erebus.items.ItemMaterials;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityPunchroom
extends EntityMob {
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;

    public EntityPunchroom(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(1.0f, 1.0f);
        this.field_70765_h = new PunchroomMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIPunchroomFloat(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPunchroomAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIPunchroomFaceRandom(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIPunchroomHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 20.0 : 20.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 2.0 : 2.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70099_a(ItemMaterials.EnumErebusMaterialsType.ELASTIC_FIBRE.createStack(1 + looting), 0.0f);
        }
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 2;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.wasOnGround = compound.func_74767_n("wasOnGround");
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            for (int j = 0; j < 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * 0.5f * f1;
                if (!this.func_130014_f_().field_72995_K) continue;
                Erebus.PROXY.spawnCustomParticle("spores", this.func_130014_f_(), this.field_70165_t + (double)f2, this.func_174813_aQ().field_72338_b, this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -1.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 2.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        float knockback = 0.2f;
        if (!player.field_71075_bZ.field_75098_d && !this.func_130014_f_().field_72995_K) {
            if (player.func_174813_aQ().field_72337_e >= this.func_174813_aQ().field_72338_b && player.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72337_e && this.func_130014_f_().func_175659_aa().ordinal() > 1) {
                if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL) {
                    knockback = 0.4f;
                } else if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
                    knockback = 0.6f;
                }
            }
            player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() : this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
            player.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 3.141593f / 180.0f)) * knockback), 0.3, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * 3.141593f / 180.0f)) * knockback));
        }
    }

    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 3.95f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187880_fp;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    protected SoundEvent getSquishSound() {
        return SoundEvents.field_187886_fs;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.5;
        this.field_70160_al = true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187882_fq;
    }

    static class PunchroomMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntityPunchroom punchroom;
        private boolean isAggressive;

        public PunchroomMoveHelper(EntityPunchroom punchroomIn) {
            super((EntityLiving)punchroomIn);
            this.punchroom = punchroomIn;
            this.yRot = 180.0f * punchroomIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float rotationY, boolean aggressive) {
            this.yRot = rotationY;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.punchroom.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.punchroom.func_70683_ar().func_75660_a();
                        this.punchroom.func_184185_a(this.punchroom.getJumpSound(), this.punchroom.func_70599_aP(), ((this.punchroom.func_70681_au().nextFloat() - this.punchroom.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 2.8f);
                    } else {
                        this.punchroom.field_70702_br = 0.0f;
                        this.punchroom.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AIPunchroomHop
    extends EntityAIBase {
        private final EntityPunchroom punchroom;

        public AIPunchroomHop(EntityPunchroom punchroomIn) {
            this.punchroom = punchroomIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((PunchroomMoveHelper)this.punchroom.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AIPunchroomFloat
    extends EntityAIBase {
        private final EntityPunchroom punchroom;

        public AIPunchroomFloat(EntityPunchroom punchroomIn) {
            this.punchroom = punchroomIn;
            this.func_75248_a(5);
            ((PathNavigateGround)punchroomIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.punchroom.func_70090_H() || this.punchroom.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.punchroom.func_70681_au().nextFloat() < 0.8f) {
                this.punchroom.func_70683_ar().func_75660_a();
            }
            ((PunchroomMoveHelper)this.punchroom.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AIPunchroomFaceRandom
    extends EntityAIBase {
        private final EntityPunchroom punchroom;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AIPunchroomFaceRandom(EntityPunchroom punchroomIn) {
            this.punchroom = punchroomIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.punchroom.func_70638_az() == null && (this.punchroom.field_70122_E || this.punchroom.func_70090_H() || this.punchroom.func_180799_ab() || this.punchroom.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.punchroom.func_70681_au().nextInt(60);
                this.chosenDegrees = this.punchroom.func_70681_au().nextInt(360);
            }
            ((PunchroomMoveHelper)this.punchroom.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AIPunchroomAttack
    extends EntityAIBase {
        private final EntityPunchroom punchroom;
        private int growTieredTimer;

        public AIPunchroomAttack(EntityPunchroom punchroomIn) {
            this.punchroom = punchroomIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.punchroom.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.punchroom.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.punchroom.func_70625_a((Entity)this.punchroom.func_70638_az(), 10.0f, 10.0f);
            ((PunchroomMoveHelper)this.punchroom.func_70605_aq()).setDirection(this.punchroom.field_70177_z, true);
        }
    }
}

