/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityBotFlyLarva
extends EntityMob
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> PARASITE_COUNT = EntityDataManager.func_187226_a(EntityBotFlyLarva.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<String> INFESTED_PLAYER = EntityDataManager.func_187226_a(EntityBotFlyLarva.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityBotFlyLarva(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.2f);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PARASITE_COUNT, (Object)new Byte(1));
        this.field_70180_af.func_187214_a(INFESTED_PLAYER, (Object)"");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.6f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_190530_aW() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187852_fb, 0.15f, 1.0f);
    }

    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        if (!this.func_130014_f_().field_72995_K && !player.func_184207_aI()) {
            this.func_184205_a((Entity)player, true);
            this.setPersistanceOnPlayer(player.func_174793_f().func_70005_c_());
        }
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            return this.func_184187_bx().field_70131_O - 2.25f;
        }
        if (this.func_184187_bx() != null) {
            return (double)this.func_184187_bx().field_70131_O * 0.75 - 1.0;
        }
        return super.func_70033_W();
    }

    public void func_70071_h_() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            this.func_70101_b(this.func_184187_bx().field_70177_z, 0.0f);
            if (!this.func_130014_f_().field_72995_K) {
                if (this.getParasiteCount() > 0 && this.field_70146_Z.nextInt(180 / this.getParasiteCount()) == 0) {
                    byte duration = (byte)(this.getParasiteCount() * 5);
                    ((EntityLivingBase)this.func_184187_bx()).func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration * 20, 0));
                    ((EntityLivingBase)this.func_184187_bx()).func_70690_d(new PotionEffect(MobEffects.field_76419_f, duration * 20, 0));
                    ((EntityLivingBase)this.func_184187_bx()).func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration * 20, 0));
                }
                if (this.getParasiteCount() == 0) {
                    this.func_70106_y();
                }
            }
        }
        super.func_70071_h_();
    }

    public void setABitDead() {
        this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), this.func_184615_bR(), SoundCategory.HOSTILE, 1.0f, 0.7f);
        if (this.func_130014_f_().field_72995_K) {
            this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.func_70099_a(new ItemStack(Items.field_151123_aH), 0.0f);
        }
        this.setParasiteCount((byte)(this.getParasiteCount() - 1));
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void setParasiteCount(byte parasites) {
        this.field_70180_af.func_187227_b(PARASITE_COUNT, (Object)parasites);
    }

    public byte getParasiteCount() {
        return (Byte)this.field_70180_af.func_187225_a(PARASITE_COUNT);
    }

    private void setPersistanceOnPlayer(String entityName) {
        this.field_70180_af.func_187227_b(INFESTED_PLAYER, (Object)entityName);
    }

    public String getPersistanceOnPlayer() {
        return (String)this.field_70180_af.func_187225_a(INFESTED_PLAYER);
    }

    public EntityPlayer playerName() {
        return this.func_130014_f_().func_72924_a(this.getPersistanceOnPlayer());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setParasiteCount(nbt.func_74771_c("parasites"));
        this.setPersistanceOnPlayer(nbt.func_74779_i("playerName"));
        if (this.playerName() != null) {
            EntityPlayer player = this.playerName();
            if (!this.func_130014_f_().field_72995_K && !player.func_184207_aI()) {
                this.func_184205_a((Entity)player, true);
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("parasites", this.getParasiteCount());
        nbt.func_74778_a("playerName", this.getPersistanceOnPlayer());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte((int)this.getParasiteCount());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setParasiteCount(additionalData.readByte());
    }
}

