/*
 * Decompiled with CFR 0.152.
 */
package erebus.core.handler;

import erebus.ModBlocks;
import erebus.blocks.BlockBones;
import erebus.core.capabilities.player.IPlayerDeathLocationCapability;
import erebus.core.capabilities.player.PlayerDeathLocationCapability;
import erebus.core.helper.Utils;
import erebus.tileentity.TileEntityBones;
import java.util.Calendar;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityDeathInventoryHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDrops(PlayerDropsEvent event) {
        List drops = event.getDrops();
        if (drops.isEmpty()) {
            return;
        }
        World world = event.getEntityLiving().field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer && !world.func_82736_K().func_82766_b("keepInventory")) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IPlayerDeathLocationCapability cap = (IPlayerDeathLocationCapability)player.getCapability(PlayerDeathLocationCapability.CAPABILITY_PLAYER_DEATH_LOCATION, null);
            BlockPos pos = player.func_180425_c().func_177984_a();
            BlockPos posBones = player.func_180425_c();
            EnumFacing playerFacing = player.func_174811_aO();
            for (EnumFacing offset : EnumFacing.field_82609_l) {
                if (!world.func_180495_p(pos.func_177972_a(offset)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177972_a(offset))) continue;
                posBones = pos.func_177972_a(offset);
                break;
            }
            world.func_180501_a(posBones, ModBlocks.BLOCK_OF_BONES.func_176223_P().func_177226_a((IProperty)BlockBones.field_176387_N, (Comparable)playerFacing), 3);
            cap.setGraveDimension(player.field_70170_p.field_73011_w.getDimension());
            cap.setGraveDimensionName(player.field_70170_p.field_73011_w.func_186058_p().func_186065_b());
            cap.setGraveLocationX(posBones.func_177958_n());
            cap.setGraveLocationZ(posBones.func_177952_p());
            cap.setDeathTime(this.getDeathTimeNow());
            TileEntityBones tile = Utils.getTileEntity((IBlockAccess)world, new BlockPos((Vec3i)posBones), TileEntityBones.class);
            if (tile != null) {
                int index = 0;
                for (int i = 0; i < drops.size() && index < 86 && index < drops.size(); ++i) {
                    ItemStack stack;
                    EntityItem entityitem;
                    if ((entityitem = (EntityItem)drops.get(index++)) == null || (stack = entityitem.func_92059_d()) == null) continue;
                    tile.func_70299_a(i, stack.func_77946_l());
                    entityitem.func_70106_y();
                }
                tile.setOwner("R.I.P. " + player.func_174793_f().func_70005_c_());
                event.setCanceled(true);
            }
        }
    }

    public String getDeathTimeNow() {
        String[] MONTH = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        String month = MONTH[Calendar.getInstance().get(2)];
        String day = String.valueOf(Calendar.getInstance().get(5));
        String year = String.valueOf(Calendar.getInstance().get(1));
        String hour = String.valueOf(Calendar.getInstance().get(11));
        String minute = String.valueOf(Calendar.getInstance().get(12));
        String second = String.valueOf(Calendar.getInstance().get(13));
        String total = (hour.length() == 1 ? '0' + hour : hour) + ":" + (minute.length() == 1 ? '0' + minute : minute) + ":" + (second.length() == 1 ? '0' + second : second) + " " + (day.length() == 1 ? '0' + day : day) + "/" + month + "/" + year;
        return total;
    }
}

