/*
 * Decompiled with CFR 0.152.
 */
package erebus;

import erebus.world.biomes.BiomeBaseErebus;
import erebus.world.biomes.BiomeElysianFields;
import erebus.world.biomes.BiomeFungalForest;
import erebus.world.biomes.BiomePetrifiedForest;
import erebus.world.biomes.BiomeSubmergedSwamp;
import erebus.world.biomes.BiomeSubterraneanSavannah;
import erebus.world.biomes.BiomeUlteriorOutback;
import erebus.world.biomes.BiomeUndergroundJungle;
import erebus.world.biomes.BiomeVolcanicDesert;
import java.util.ArrayList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

@GameRegistry.ObjectHolder(value="erebus")
public class ModBiomes {
    public static ArrayList<BiomeBaseErebus> BIOME_LIST = new ArrayList();
    public static BiomeBaseErebus UNDERGROUND_JUNGLE;
    public static BiomeBaseErebus VOLCANIC_DESERT;
    public static BiomeBaseErebus SUBTERRANEAN_SAVANNAH;
    public static BiomeBaseErebus ELYSIAN_FIELDS;
    public static BiomeBaseErebus ULTERIOR_OUTBACK;
    public static BiomeBaseErebus FUNGAL_FOREST;
    public static BiomeBaseErebus SUBMERGED_SWAMP;
    public static BiomeBaseErebus FIELDS_SUB_FOREST;
    public static BiomeBaseErebus PETRIFIED_FOREST;

    public static void init() {
        UNDERGROUND_JUNGLE = new BiomeUndergroundJungle(new Biome.BiomeProperties("Underground Jungle"));
        VOLCANIC_DESERT = new BiomeVolcanicDesert(new Biome.BiomeProperties("Volcanic Desert"));
        SUBTERRANEAN_SAVANNAH = new BiomeSubterraneanSavannah(new Biome.BiomeProperties("Subterranean Savannah"));
        ELYSIAN_FIELDS = new BiomeElysianFields(new Biome.BiomeProperties("Elysian Fields"));
        ULTERIOR_OUTBACK = new BiomeUlteriorOutback(new Biome.BiomeProperties("Ulterior Outback"));
        FUNGAL_FOREST = new BiomeFungalForest(new Biome.BiomeProperties("Fungal Forest"));
        SUBMERGED_SWAMP = new BiomeSubmergedSwamp(new Biome.BiomeProperties("Submerged Swamp"));
        FIELDS_SUB_FOREST = new BiomeElysianFields.BiomeElysianForest(new Biome.BiomeProperties("Elysian Forest"));
        PETRIFIED_FOREST = new BiomePetrifiedForest(new Biome.BiomeProperties("Petrified Forest"));
        BiomeBaseErebus.func_185356_b((Biome)UNDERGROUND_JUNGLE);
        BiomeBaseErebus.func_185356_b((Biome)VOLCANIC_DESERT);
        BiomeBaseErebus.func_185356_b((Biome)SUBTERRANEAN_SAVANNAH);
        BiomeBaseErebus.func_185356_b((Biome)ELYSIAN_FIELDS);
        BiomeBaseErebus.func_185356_b((Biome)ULTERIOR_OUTBACK);
        BiomeBaseErebus.func_185356_b((Biome)FUNGAL_FOREST);
        BiomeBaseErebus.func_185356_b((Biome)SUBMERGED_SWAMP);
        BiomeBaseErebus.func_185356_b((Biome)FIELDS_SUB_FOREST);
        BiomeBaseErebus.func_185356_b((Biome)PETRIFIED_FOREST);
    }

    @Mod.EventBusSubscriber(modid="erebus")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            ModBiomes.init();
            IForgeRegistry registry = event.getRegistry();
            RegistrationHandler.registerBiome((IForgeRegistry<Biome>)registry, UNDERGROUND_JUNGLE, "underground_jungle", BiomeManager.BiomeType.WARM, 22, BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
            RegistrationHandler.registerBiome((IForgeRegistry<Biome>)registry, VOLCANIC_DESERT, "volcanic_desert", BiomeManager.BiomeType.WARM, 16, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
            RegistrationHandler.registerBiome((IForgeRegistry<Biome>)registry, SUBTERRANEAN_SAVANNAH, "subterranean_savannah", BiomeManager.BiomeType.WARM, 20, BiomeDictionary.Type.SAVANNA);
            RegistrationHandler.registerBiome((IForgeRegistry<Biome>)registry, ELYSIAN_FIELDS, "elysian_fields", BiomeManager.BiomeType.WARM, 20, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS);
            RegistrationHandler.registerBiome((IForgeRegistry<Biome>)registry, ULTERIOR_OUTBACK, "ulterior_outback", BiomeManager.BiomeType.WARM, 15, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
            RegistrationHandler.registerBiome((IForgeRegistry<Biome>)registry, FUNGAL_FOREST, "fungal_forest", BiomeManager.BiomeType.WARM, 12, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.SPOOKY);
            RegistrationHandler.registerBiome((IForgeRegistry<Biome>)registry, SUBMERGED_SWAMP, "submerged_swamp", BiomeManager.BiomeType.WARM, 20, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER, BiomeDictionary.Type.SWAMP);
            RegistrationHandler.registerBiome((IForgeRegistry<Biome>)registry, FIELDS_SUB_FOREST, "fields_sub_forest", BiomeManager.BiomeType.WARM, 0, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL);
            RegistrationHandler.registerBiome((IForgeRegistry<Biome>)registry, PETRIFIED_FOREST, "petrified_forest", BiomeManager.BiomeType.WARM, 15, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD);
        }

        private static <T extends Biome> void registerBiome(IForgeRegistry<Biome> registry, T biome, String biomeName, BiomeManager.BiomeType biomeType, int weight, BiomeDictionary.Type ... types) {
            registry.register(biome.setRegistryName("erebus", biomeName));
            BiomeDictionary.addTypes(biome, (BiomeDictionary.Type[])types);
            for (int x = 0; x < weight; ++x) {
                BIOME_LIST.add((BiomeBaseErebus)biome);
            }
        }
    }
}

