/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.biome.BiomeBOP;
import biomesoplenty.common.biome.end.DeadReefBiome;
import biomesoplenty.common.biome.end.EtherealForestBiome;
import biomesoplenty.common.biome.nether.AshenInfernoBiome;
import biomesoplenty.common.biome.nether.FungiForestBiome;
import biomesoplenty.common.biome.nether.GlowstoneGrottoBiome;
import biomesoplenty.common.biome.nether.UndergardenBiome;
import biomesoplenty.common.biome.nether.VisceralHeapBiome;
import biomesoplenty.common.biome.overworld.AlpsBiome;
import biomesoplenty.common.biome.overworld.AlpsFoothillsBiome;
import biomesoplenty.common.biome.overworld.BayouBiome;
import biomesoplenty.common.biome.overworld.BogBiome;
import biomesoplenty.common.biome.overworld.BorealForestBiome;
import biomesoplenty.common.biome.overworld.BrushlandBiome;
import biomesoplenty.common.biome.overworld.ChaparralBiome;
import biomesoplenty.common.biome.overworld.CherryBlossomGroveBiome;
import biomesoplenty.common.biome.overworld.ColdDesertBiome;
import biomesoplenty.common.biome.overworld.ConiferousForestBiome;
import biomesoplenty.common.biome.overworld.DeadForestBiome;
import biomesoplenty.common.biome.overworld.FirClearingBiome;
import biomesoplenty.common.biome.overworld.FloodplainBiome;
import biomesoplenty.common.biome.overworld.FlowerMeadowBiome;
import biomesoplenty.common.biome.overworld.GrasslandBiome;
import biomesoplenty.common.biome.overworld.GravelBeachBiome;
import biomesoplenty.common.biome.overworld.GroveBiome;
import biomesoplenty.common.biome.overworld.HighlandBiome;
import biomesoplenty.common.biome.overworld.HighlandMoorBiome;
import biomesoplenty.common.biome.overworld.LavenderFieldBiome;
import biomesoplenty.common.biome.overworld.LushGrasslandBiome;
import biomesoplenty.common.biome.overworld.LushSwampBiome;
import biomesoplenty.common.biome.overworld.MangroveBiome;
import biomesoplenty.common.biome.overworld.MapleWoodsBiome;
import biomesoplenty.common.biome.overworld.MarshBiome;
import biomesoplenty.common.biome.overworld.MeadowBiome;
import biomesoplenty.common.biome.overworld.MireBiome;
import biomesoplenty.common.biome.overworld.MysticGroveBiome;
import biomesoplenty.common.biome.overworld.OasisBiome;
import biomesoplenty.common.biome.overworld.OminousWoodsBiome;
import biomesoplenty.common.biome.overworld.OrchardBiome;
import biomesoplenty.common.biome.overworld.OriginBeachBiome;
import biomesoplenty.common.biome.overworld.OriginHillsBiome;
import biomesoplenty.common.biome.overworld.OutbackBiome;
import biomesoplenty.common.biome.overworld.OvergrownCliffsBiome;
import biomesoplenty.common.biome.overworld.PastureBiome;
import biomesoplenty.common.biome.overworld.PrairieBiome;
import biomesoplenty.common.biome.overworld.PumpkinPatchBiome;
import biomesoplenty.common.biome.overworld.RainforestBiome;
import biomesoplenty.common.biome.overworld.RedwoodForestBiome;
import biomesoplenty.common.biome.overworld.RedwoodForestEdgeBiome;
import biomesoplenty.common.biome.overworld.ScrublandBiome;
import biomesoplenty.common.biome.overworld.SeasonalForestBiome;
import biomesoplenty.common.biome.overworld.ShieldBiome;
import biomesoplenty.common.biome.overworld.ShrublandBiome;
import biomesoplenty.common.biome.overworld.SilkgladeBiome;
import biomesoplenty.common.biome.overworld.SnowyConiferousForestBiome;
import biomesoplenty.common.biome.overworld.SnowyFirClearingBiome;
import biomesoplenty.common.biome.overworld.SnowyForestBiome;
import biomesoplenty.common.biome.overworld.SteppeBiome;
import biomesoplenty.common.biome.overworld.TemperateRainforestBiome;
import biomesoplenty.common.biome.overworld.TemperateRainforestHillsBiome;
import biomesoplenty.common.biome.overworld.TropicalRainforestBiome;
import biomesoplenty.common.biome.overworld.TropicsBiome;
import biomesoplenty.common.biome.overworld.TundraBiome;
import biomesoplenty.common.biome.overworld.VolcanoBiome;
import biomesoplenty.common.biome.overworld.VolcanoEdgeBiome;
import biomesoplenty.common.biome.overworld.WastelandBiome;
import biomesoplenty.common.biome.overworld.WetlandBiome;
import biomesoplenty.common.biome.overworld.WhiteBeachBiome;
import biomesoplenty.common.biome.overworld.WoodlandBiome;
import biomesoplenty.common.biome.overworld.XericShrublandBiome;
import biomesoplenty.common.world.WorldTypeBOP;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    public static WorldTypeBOP worldType;
    public static Multimap<Integer, WeightedSubBiome> subBiomes;
    public static List<Integer> islandBiomes;

    public static void setup() {
        worldType = new WorldTypeBOP();
        ModBiomes.registerBiomeDictionaryTags();
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        BOPBiomes.mangrove = ModBiomes.registerBiome(new MangroveBiome(), "mangrove");
        BOPBiomes.gravel_beach = ModBiomes.registerBiome(new GravelBeachBiome(), "gravel_beach");
        BOPBiomes.origin_beach = ModBiomes.registerBiome(new OriginBeachBiome(), "origin_beach");
        BOPBiomes.white_beach = ModBiomes.registerBiome(new WhiteBeachBiome(), "white_beach");
        BOPBiomes.alps_foothills = ModBiomes.registerBiome(new AlpsFoothillsBiome(), "alps_foothills");
        BOPBiomes.redwood_forest_edge = ModBiomes.registerBiome(new RedwoodForestEdgeBiome(), "redwood_forest_edge");
        BOPBiomes.volcano_edge = ModBiomes.registerBiome(new VolcanoEdgeBiome(), "volcano_edge");
        BOPBiomes.alps = ModBiomes.registerBiome(new AlpsBiome(), "alps");
        BOPBiomes.bayou = ModBiomes.registerBiome(new BayouBiome(), "bayou");
        BOPBiomes.bog = ModBiomes.registerBiome(new BogBiome(), "bog");
        BOPBiomes.boreal_forest = ModBiomes.registerBiome(new BorealForestBiome(), "boreal_forest");
        BOPBiomes.brushland = ModBiomes.registerBiome(new BrushlandBiome(), "brushland");
        BOPBiomes.chaparral = ModBiomes.registerBiome(new ChaparralBiome(), "chaparral");
        BOPBiomes.cherry_blossom_grove = ModBiomes.registerBiome(new CherryBlossomGroveBiome(), "cherry_blossom_grove");
        BOPBiomes.cold_desert = ModBiomes.registerBiome(new ColdDesertBiome(), "cold_desert");
        BOPBiomes.coniferous_forest = ModBiomes.registerBiome(new ConiferousForestBiome(), "coniferous_forest");
        BOPBiomes.dead_forest = ModBiomes.registerBiome(new DeadForestBiome(), "dead_forest");
        BOPBiomes.fir_clearing = ModBiomes.registerBiome(new FirClearingBiome(), "fir_clearing");
        BOPBiomes.floodplain = ModBiomes.registerBiome(new FloodplainBiome(), "floodplain");
        BOPBiomes.flower_meadow = ModBiomes.registerBiome(new FlowerMeadowBiome(), "flower_meadow");
        BOPBiomes.grassland = ModBiomes.registerBiome(new GrasslandBiome(), "grassland");
        BOPBiomes.grove = ModBiomes.registerBiome(new GroveBiome(), "grove");
        BOPBiomes.orchard = ModBiomes.registerBiome(new OrchardBiome(), "orchard");
        BOPBiomes.highland = ModBiomes.registerBiome(new HighlandBiome(), "highland");
        BOPBiomes.highland_moor = ModBiomes.registerBiome(new HighlandMoorBiome(), "highland_moor");
        BOPBiomes.lavender_field = ModBiomes.registerBiome(new LavenderFieldBiome(), "lavender_field");
        BOPBiomes.lush_grassland = ModBiomes.registerBiome(new LushGrasslandBiome(), "lush_grassland");
        BOPBiomes.lush_swamp = ModBiomes.registerBiome(new LushSwampBiome(), "lush_swamp");
        BOPBiomes.maple_woods = ModBiomes.registerBiome(new MapleWoodsBiome(), "maple_woods");
        BOPBiomes.marsh = ModBiomes.registerBiome(new MarshBiome(), "marsh");
        BOPBiomes.meadow = ModBiomes.registerBiome(new MeadowBiome(), "meadow");
        BOPBiomes.mire = ModBiomes.registerBiome(new MireBiome(), "mire");
        BOPBiomes.mystic_grove = ModBiomes.registerBiome(new MysticGroveBiome(), "mystic_grove");
        BOPBiomes.oasis = ModBiomes.registerBiome(new OasisBiome(), "oasis");
        BOPBiomes.ominous_woods = ModBiomes.registerBiome(new OminousWoodsBiome(), "ominous_woods");
        BOPBiomes.origin_hills = ModBiomes.registerBiome(new OriginHillsBiome(), "origin_hills");
        BOPBiomes.outback = ModBiomes.registerBiome(new OutbackBiome(), "outback");
        BOPBiomes.overgrown_cliffs = ModBiomes.registerBiome(new OvergrownCliffsBiome(), "overgrown_cliffs");
        BOPBiomes.pasture = ModBiomes.registerBiome(new PastureBiome(), "pasture");
        BOPBiomes.prairie = ModBiomes.registerBiome(new PrairieBiome(), "prairie");
        BOPBiomes.pumpkin_patch = ModBiomes.registerBiome(new PumpkinPatchBiome(), "pumpkin_patch");
        BOPBiomes.rainforest = ModBiomes.registerBiome(new RainforestBiome(), "rainforest");
        BOPBiomes.redwood_forest = ModBiomes.registerBiome(new RedwoodForestBiome(), "redwood_forest");
        BOPBiomes.scrubland = ModBiomes.registerBiome(new ScrublandBiome(), "scrubland");
        BOPBiomes.seasonal_forest = ModBiomes.registerBiome(new SeasonalForestBiome(), "seasonal_forest");
        BOPBiomes.shield = ModBiomes.registerBiome(new ShieldBiome(), "shield");
        BOPBiomes.shrubland = ModBiomes.registerBiome(new ShrublandBiome(), "shrubland");
        BOPBiomes.silkglade = ModBiomes.registerBiome(new SilkgladeBiome(), "silkglade");
        BOPBiomes.snowy_coniferous_forest = ModBiomes.registerBiome(new SnowyConiferousForestBiome(), "snowy_coniferous_forest");
        BOPBiomes.snowy_fir_clearing = ModBiomes.registerBiome(new SnowyFirClearingBiome(), "snowy_fir_clearing");
        BOPBiomes.snowy_forest = ModBiomes.registerBiome(new SnowyForestBiome(), "snowy_forest");
        BOPBiomes.steppe = ModBiomes.registerBiome(new SteppeBiome(), "steppe");
        BOPBiomes.temperate_rainforest = ModBiomes.registerBiome(new TemperateRainforestBiome(), "temperate_rainforest");
        BOPBiomes.temperate_rainforest_hills = ModBiomes.registerBiome(new TemperateRainforestHillsBiome(), "temperate_rainforest_hills");
        BOPBiomes.tropical_rainforest = ModBiomes.registerBiome(new TropicalRainforestBiome(), "tropical_rainforest");
        BOPBiomes.tropics = ModBiomes.registerBiome(new TropicsBiome(), "tropics");
        BOPBiomes.tundra = ModBiomes.registerBiome(new TundraBiome(), "tundra");
        BOPBiomes.volcano = ModBiomes.registerBiome(new VolcanoBiome(), "volcano");
        BOPBiomes.wasteland = ModBiomes.registerBiome(new WastelandBiome(), "wasteland");
        BOPBiomes.wetland = ModBiomes.registerBiome(new WetlandBiome(), "wetland");
        BOPBiomes.woodland = ModBiomes.registerBiome(new WoodlandBiome(), "woodland");
        BOPBiomes.xeric_shrubland = ModBiomes.registerBiome(new XericShrublandBiome(), "xeric_shrubland");
        BOPBiomes.ashen_inferno = ModBiomes.registerBiome(new AshenInfernoBiome(), "ashen_inferno");
        BOPBiomes.fungi_forest = ModBiomes.registerBiome(new FungiForestBiome(), "fungi_forest");
        BOPBiomes.glowstone_grotto = ModBiomes.registerBiome(new GlowstoneGrottoBiome(), "glowstone_grotto");
        BOPBiomes.undergarden = ModBiomes.registerBiome(new UndergardenBiome(), "undergarden");
        BOPBiomes.visceral_heap = ModBiomes.registerBiome(new VisceralHeapBiome(), "visceral_heap");
        BOPBiomes.dead_reef = ModBiomes.registerBiome(new DeadReefBiome(), "dead_reef");
        BOPBiomes.ethereal_forest = ModBiomes.registerBiome(new EtherealForestBiome(), "ethereal_forest");
        ModBiomes.registerSubBiome(Biomes.field_76769_d, BOPBiomes.oasis, 0.1f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.brushland, BOPBiomes.xeric_shrubland, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.coniferous_forest, BOPBiomes.fir_clearing, 0.38f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.highland, BOPBiomes.highland_moor, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.meadow, BOPBiomes.flower_meadow, 0.5f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.prairie, BOPBiomes.pasture, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.seasonal_forest, BOPBiomes.pumpkin_patch, 0.45f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.snowy_coniferous_forest, BOPBiomes.snowy_fir_clearing, 0.5f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.temperate_rainforest, BOPBiomes.temperate_rainforest_hills, 0.9f, 100);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_hills, BOPClimates.COOL_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_hills, BOPClimates.DRY_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_hills, BOPClimates.WET_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.WARM_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.MEDITERRANEAN, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.SAVANNA, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.SUBTROPICAL, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.TROPICAL, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.HOT_DESERT, 50);
    }

    private static void registerBiomeDictionaryTags() {
        ModBiomes.registerBiomeToDictionary(BOPBiomes.alps, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.alps_foothills, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bayou, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bog, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.boreal_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.brushland, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.chaparral, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cherry_blossom_grove, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cold_desert, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.DRY, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.coniferous_forest, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dead_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fir_clearing, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.floodplain, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WATER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.flower_meadow, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grassland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.gravel_beach, BiomeDictionary.Type.BEACH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grove, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.highland, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.highland_moor, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lavender_field, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_grassland, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET, BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_swamp, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mangrove, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.maple_woods, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.marsh, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.meadow, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mire, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mystic_grove, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.oasis, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ominous_woods, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.orchard, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.origin_beach, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.origin_hills, BiomeDictionary.Type.WATER, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.outback, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.overgrown_cliffs, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.pasture, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.prairie, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.pumpkin_patch, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.rainforest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.redwood_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.redwood_forest_edge, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.scrubland, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.seasonal_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shield, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shrubland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.silkglade, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_coniferous_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_fir_clearing, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_forest, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.steppe, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.temperate_rainforest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.temperate_rainforest_hills, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropical_rainforest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropics, BiomeDictionary.Type.WATER, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tundra, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.volcano, BiomeDictionary.Type.WATER, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.volcano_edge, BiomeDictionary.Type.WATER, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wasteland, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wetland, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.white_beach, BiomeDictionary.Type.BEACH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.woodland, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.xeric_shrubland, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ashen_inferno, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fungi_forest, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.glowstone_grotto, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.undergarden, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.visceral_heap, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dead_reef, BiomeDictionary.Type.END);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ethereal_forest, BiomeDictionary.Type.END);
    }

    private static void registerBiomeToDictionary(Optional<Biome> biome, BiomeDictionary.Type ... types) {
        if (biome.isPresent()) {
            BiomeDictionary.addTypes((Biome)biome.get(), (BiomeDictionary.Type[])types);
        }
    }

    public static Optional<Biome> registerBiome(BiomeBOP biome, String name) {
        biome.setRegistryName(name);
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        if (biome.canSpawnInBiome) {
            BiomeManager.addSpawnBiome((Biome)biome);
        }
        for (Map.Entry<BOPClimates, Integer> entry : biome.getWeightMap().entrySet()) {
            if (entry == null) continue;
            BOPClimates climate = entry.getKey();
            int weight = entry.getValue();
            climate.addBiome(weight, biome);
        }
        return Optional.of(biome);
    }

    public static void registerSubBiome(Biome parent, Optional<Biome> child, float rarity, int weight) {
        if (!child.isPresent()) {
            return;
        }
        subBiomes.put((Object)Registry.field_212624_m.func_148757_b((Object)parent), (Object)new WeightedSubBiome(child.get(), rarity, weight));
    }

    public static void registerSubBiome(Optional<Biome> parent, Optional<Biome> child, float rarity, int weight) {
        if (!parent.isPresent()) {
            return;
        }
        if (!child.isPresent()) {
            return;
        }
        subBiomes.put((Object)Registry.field_212624_m.func_148757_b((Object)parent.get()), (Object)new WeightedSubBiome(child.get(), rarity, weight));
    }

    public static void registerIslandBiome(Biome biome, BOPClimates climate, int weight) {
        islandBiomes.add(Registry.field_212624_m.func_148757_b((Object)biome));
        climate.addIslandBiome(weight, biome);
    }

    public static void registerIslandBiome(Optional<Biome> biome, BOPClimates climate, int weight) {
        if (!biome.isPresent()) {
            return;
        }
        ModBiomes.registerIslandBiome(biome.get(), climate, weight);
    }

    static {
        subBiomes = HashMultimap.create();
        islandBiomes = Lists.newArrayList();
    }

    public static class WeightedSubBiome {
        public final Biome biome;
        public final float rarity;
        public final int weight;

        public WeightedSubBiome(Biome biome, float rarity, int weight) {
            this.biome = biome;
            this.rarity = rarity;
            this.weight = weight;
        }
    }
}

